/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.props;

import java.time.LocalTime;
import java.time.temporal.ChronoField;
import javax.annotation.Nonnull;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import tauri.dev.jsg.loader.ElementEnum;
import tauri.dev.jsg.renderer.AncientRenderer;
import tauri.dev.jsg.renderer.props.DestinyCountDownRendererState;
import tauri.dev.jsg.tileentity.props.DestinyCountDownTile;
import tauri.dev.jsg.util.FacingHelper;
import tauri.dev.jsg.util.JSGTextureLightningHelper;
import tauri.dev.jsg.util.main.JSGProps;

public class DestinyCountDownRenderer
extends TileEntitySpecialRenderer<DestinyCountDownTile> {
    public void render(@Nonnull DestinyCountDownTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        DestinyCountDownRendererState rs = te.getRendererState();
        if (rs != null) {
            boolean clock = te.getConfig().getOption(DestinyCountDownTile.ConfigOptions.SWITCH_TO_CLOCK.id).getBooleanValue() && te.countdownTo == -1L;
            long ticks = te.getCountdownTicks();
            if (clock) {
                ticks = Math.round((double)LocalTime.now().getLong(ChronoField.MILLI_OF_DAY) / 1000.0 * 20.0);
            }
            if (ticks < 0L) {
                ticks = 0L;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            IBlockState blockState = te.func_145831_w().func_180495_p(te.func_174877_v());
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)JSGProps.FACING_HORIZONTAL);
            GlStateManager.func_179094_E();
            int rot = FacingHelper.getIntRotation(facing, false);
            GlStateManager.func_179114_b((float)(rot + 180), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.5);
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)0.03, (double)0.03, (double)0.03);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            ElementEnum.DESTINY_COUNTDOWN.bindTextureAndRender();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            JSGTextureLightningHelper.lightUpTexture(1.0f);
            GlStateManager.func_179137_b((double)0.007, (double)0.05, (double)0.07);
            GlStateManager.func_179139_a((double)0.01, (double)0.01, (double)0.01);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            AncientRenderer.renderClock(ticks, clock, te.countdownTo, false);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
        }
    }
}

