/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.effect;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class DestinyFTL {
    private static World world;
    private static long tickStart;
    public static boolean jumpingIn;
    public static boolean jumpingOut;
    public static float defaultFov;
    private static final double TOTAL_EFFECT_TIME_IN = 60.0;
    private static final double TOTAL_EFFECT_TIME_OUT = 60.0;

    public static double calcFog(World world, long tickStart, double partialTicks, boolean out) {
        double effTick = (double)(world.func_82737_E() - tickStart) + partialTicks;
        double total = out ? 60.0 : 60.0;
        double tick = effTick / total;
        return tick < total ? Math.min(1.0, Math.sin(Math.toRadians(tick * 180.0)) * 1.4) : -1.0;
    }

    @SubscribeEvent
    public static void onRender(RenderGameOverlayEvent.Post event) {
        if (jumpingIn || jumpingOut) {
            float fog = (float)DestinyFTL.calcFog(world, tickStart, event.getPartialTicks(), jumpingOut);
            if (fog < 0.0f) {
                jumpingIn = false;
                jumpingOut = false;
                Minecraft.func_71410_x().field_71474_y.func_74304_a(GameSettings.Options.FOV, defaultFov);
            } else {
                int alpha = (int)(fog * 127.0f);
                float scale = fog + 1.0f;
                alpha /= 3;
                ScaledResolution res = event.getResolution();
                Gui.func_73734_a((int)0, (int)0, (int)res.func_78326_a(), (int)res.func_78328_b(), (int)(0xFFFFFF | (alpha <<= 24)));
                float newFov = jumpingIn ? defaultFov * scale : defaultFov / scale;
                Minecraft.func_71410_x().field_71474_y.func_74304_a(GameSettings.Options.FOV, newFov);
            }
        }
    }

    public static void jumpIn(boolean in) {
        if (jumpingIn || jumpingOut) {
            return;
        }
        defaultFov = Minecraft.func_71410_x().field_71474_y.func_74296_a(GameSettings.Options.FOV);
        world = Minecraft.func_71410_x().field_71441_e;
        tickStart = world.func_82737_E();
        if (in) {
            jumpingIn = true;
        } else {
            jumpingOut = true;
        }
    }
}

