/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.dialhomedevice;

import java.awt.Color;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.item.notebook.NotebookItem;
import tauri.dev.jsg.renderer.BlockRenderer;
import tauri.dev.jsg.renderer.dialhomedevice.DHDAbstractRendererState;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;
import tauri.dev.jsg.tileentity.dialhomedevice.DHDAbstractTile;
import tauri.dev.jsg.util.JSGColorUtil;
import tauri.dev.jsg.util.JSGTextureLightningHelper;
import tauri.dev.jsg.util.main.JSGProps;

public abstract class DHDAbstractRenderer
extends TileEntitySpecialRenderer<DHDAbstractTile> {
    protected static final BlockPos ZERO_BLOCKPOS = new BlockPos(0, 0, 0);

    public void render(DHDAbstractTile te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        DHDAbstractRendererState rendererState = te.getRendererStateClient();
        if (rendererState != null) {
            IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v()).func_185899_b((IBlockAccess)te.func_145831_w(), te.func_174877_v());
            if (state.func_177230_c() != this.getDHDBlock()) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            if (((Boolean)state.func_177229_b((IProperty)JSGProps.SNOWY)).booleanValue()) {
                BlockRenderer.render(this.func_178459_a(), ZERO_BLOCKPOS, Blocks.field_150431_aC.func_176223_P(), te.func_174877_v());
            }
            GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
            GlStateManager.func_179114_b((float)rendererState.horizontalRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderDHD(rendererState, te);
            this.renderSymbols(te, rendererState, te.func_145831_w(), new BlockPos(x, y, z));
            GlStateManager.func_179121_F();
            rendererState.iterate(this.func_178459_a(), partialTicks);
        }
    }

    public abstract void renderSymbols(DHDAbstractTile var1, DHDAbstractRendererState var2, World var3, BlockPos var4);

    public abstract void renderDHD(DHDAbstractRendererState var1, DHDAbstractTile var2);

    public abstract Block getDHDBlock();

    protected void setColorByAddress(DHDAbstractTile te, DHDAbstractRendererState rendererState, NBTTagCompound compound, SymbolTypeEnum symbolType, SymbolInterface symbol) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (compound != null && JSGConfig.DialHomeDevice.visual.enablePageHint) {
            if (compound.func_74764_b("addressList")) {
                compound = NotebookItem.getSelectedPageFromCompound(compound);
            }
            if (!compound.func_74764_b("symbolType")) {
                return;
            }
            if (!compound.func_74764_b("address")) {
                return;
            }
            SymbolTypeEnum st = SymbolTypeEnum.valueOf(compound.func_74762_e("symbolType"));
            int maxSymbols = symbolType.getMaxSymbolsDisplay(compound.func_74767_n("hasUpgrade"));
            StargateAddress stargateAddress = new StargateAddress(compound.func_74775_l("address"));
            if (st == symbolType && !rendererState.isButtonActive(symbol) && !rendererState.isButtonActive(st.getOrigin())) {
                int activatedButtons = rendererState.getActivatedButtons();
                SymbolInterface displayedSymbol = st.getOrigin();
                if (activatedButtons < maxSymbols && !rendererState.stargateIsConnected) {
                    displayedSymbol = stargateAddress.get(activatedButtons);
                }
                if ((stargateAddress.contains(symbol) || symbol.origin()) && displayedSymbol == symbol) {
                    String sColor = JSGConfig.DialHomeDevice.visual.pageHintColors.get(!symbol.origin() ? (activatedButtons < 6 ? "Normal" : "ExtraSymbols") : "Origin");
                    int color = 0xFFFFFF;
                    try {
                        color = Integer.decode(sColor);
                    }
                    catch (Exception e) {
                        JSG.error("Error while parsing color of dial helper from config!", e);
                    }
                    Color c = JSGColorUtil.toColor(color);
                    GlStateManager.func_179131_c((float)((float)c.getRed() / 255.0f), (float)((float)c.getGreen() / 255.0f), (float)((float)c.getBlue() / 255.0f), (float)((float)c.getAlpha() / 255.0f));
                    JSGTextureLightningHelper.lightUpTexture(this.func_178459_a(), rendererState.pos, 0.5f);
                }
            }
        }
    }

    public NBTTagCompound getNoteBookPage() {
        NBTTagCompound compound = null;
        ItemStack item = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
        if (item.func_77942_o()) {
            compound = item.func_77978_p();
        } else {
            item = Minecraft.func_71410_x().field_71439_g.func_184586_b(EnumHand.OFF_HAND);
            if (item.func_77942_o()) {
                compound = item.func_77978_p();
            }
        }
        return compound;
    }
}

