/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.renderer.biomes;

import java.util.EnumSet;
import java.util.HashMap;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.config.JSGConfigUtil;
import tauri.dev.jsg.util.BlockHelpers;

public enum BiomeOverlayEnum {
    NORMAL(0, "", TextFormatting.GRAY),
    FROST(1, "_frost", TextFormatting.DARK_AQUA),
    MOSSY(2, "_mossy", TextFormatting.DARK_GREEN),
    AGED(3, "_aged", TextFormatting.GRAY),
    SOOTY(4, "_sooty", TextFormatting.DARK_GRAY),
    TR_NORMAL(10, "", TextFormatting.GOLD);

    public final String suffix;
    public final int id;
    private final TextFormatting color;
    private final String unlocalizedName;
    private static final HashMap<Integer, BiomeOverlayEnum> ID_MAP;

    private BiomeOverlayEnum(int id, String suffix, TextFormatting color) {
        this.id = id;
        this.suffix = suffix;
        this.color = color;
        this.unlocalizedName = "gui.stargate.biome_overlay." + this.name().toLowerCase();
    }

    public static BiomeOverlayEnum byId(int id) {
        return ID_MAP.get(id);
    }

    public String getLocalizedColorizedName() {
        return this.color + JSG.proxy.localize(this.unlocalizedName, new Object[0]);
    }

    public static BiomeOverlayEnum updateBiomeOverlay(World world, BlockPos topmostBlock, EnumSet<BiomeOverlayEnum> supportedOverlays) {
        BiomeOverlayEnum ret = BiomeOverlayEnum.getBiomeOverlay(world, topmostBlock);
        if (supportedOverlays.contains((Object)ret)) {
            return ret;
        }
        return NORMAL;
    }

    private static BiomeOverlayEnum getBiomeOverlay(World world, BlockPos topmostBlock) {
        Biome biome = world.func_180494_b(topmostBlock);
        if (world.field_73011_w.func_186058_p() != DimensionType.NETHER && !BlockHelpers.isBlockDirectlyUnderSky((IBlockAccess)world, topmostBlock)) {
            return NORMAL;
        }
        if (biome.func_180626_a(topmostBlock) <= JSGConfig.Stargate.visual.frostyTemperatureThreshold) {
            return FROST;
        }
        BiomeOverlayEnum overlay = JSGConfigUtil.getBiomeOverrideBiomes().get(biome);
        if (overlay != null) {
            return overlay;
        }
        return NORMAL;
    }

    public static BiomeOverlayEnum fromString(String name) {
        for (BiomeOverlayEnum biomeOverlay : BiomeOverlayEnum.values()) {
            if (!biomeOverlay.toString().equals(name)) continue;
            return biomeOverlay;
        }
        return null;
    }

    static {
        ID_MAP = new HashMap();
        for (BiomeOverlayEnum overlay : BiomeOverlayEnum.values()) {
            ID_MAP.put(overlay.id, overlay);
        }
    }
}

