/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.raycaster.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import tauri.dev.vector.Matrix3f;
import tauri.dev.vector.Vector2f;
import tauri.dev.vector.Vector3f;

public class DHDVertex {
    public final float x;
    public final float y;
    public final float z;
    private double xRotated;
    private double yRotated;
    private double zRotated;
    private double xGlobal;
    private double yGlobal;
    private double zGlobal;
    public double xDiffrence;
    public double yDiffrence;
    public double zDiffrence;
    BlockPos oldGlobal = null;
    private Vec3d lastPlayerPos = new Vec3d(0.0, 0.0, 0.0);

    public double getGlobalX() {
        return this.xGlobal;
    }

    public double getGlobalY() {
        return this.yGlobal;
    }

    public double getGlobalZ() {
        return this.zGlobal;
    }

    public DHDVertex(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public String toString() {
        return String.format("%f %f %f", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z));
    }

    public DHDVertex rotate(double angle) {
        angle = Math.toRadians(angle);
        float sin = (float)Math.sin(angle);
        float cos = (float)Math.cos(angle);
        Matrix3f rotationMatrix = new Matrix3f();
        Matrix3f vertex = new Matrix3f();
        Matrix3f out = new Matrix3f();
        rotationMatrix.m00 = cos;
        rotationMatrix.m10 = -sin;
        rotationMatrix.m20 = 0.0f;
        rotationMatrix.m01 = sin;
        rotationMatrix.m11 = cos;
        rotationMatrix.m21 = 0.0f;
        rotationMatrix.m02 = 0.0f;
        rotationMatrix.m12 = 0.0f;
        rotationMatrix.m22 = 1.0f;
        vertex.m00 = this.x;
        vertex.m01 = this.y;
        vertex.m02 = this.z;
        Matrix3f.mul(rotationMatrix, vertex, out);
        this.xRotated = out.m00;
        this.yRotated = out.m01;
        this.zRotated = out.m02;
        return this;
    }

    public DHDVertex localToGlobal(BlockPos pos, Vector3f translation) {
        if (!pos.equals((Object)this.oldGlobal)) {
            this.xGlobal = this.xRotated + (double)pos.func_177958_n() + (double)translation.x;
            this.yGlobal = this.zRotated + (double)pos.func_177956_o() + (double)translation.y;
            this.zGlobal = (double)pos.func_177952_p() - this.yRotated + (double)translation.z;
            this.oldGlobal = pos;
        }
        return this;
    }

    public DHDVertex calculateDiffrence(EntityPlayer player) {
        double posY = player.field_70163_u + (double)player.func_70047_e();
        if (this.lastPlayerPos.field_72450_a != player.field_70165_t) {
            this.xDiffrence = (float)(this.xGlobal - player.field_70165_t);
        }
        if (this.lastPlayerPos.field_72449_c != player.field_70161_v) {
            this.zDiffrence = (float)(this.zGlobal - player.field_70161_v);
        }
        if (this.lastPlayerPos.field_72448_b != player.field_70163_u) {
            this.yDiffrence = (float)(this.yGlobal - posY);
        }
        this.lastPlayerPos = new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        return this;
    }

    public Vector2f getViewport(Vec3d lookVec) {
        double xy = this.xDiffrence / this.yDiffrence;
        double zy = this.zDiffrence / this.yDiffrence;
        float x = (float)(lookVec.field_72448_b * xy);
        float z = (float)(lookVec.field_72448_b * zy);
        return new Vector2f(x, z);
    }
}

