/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.item.linkable.dialer;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import tauri.dev.jsg.item.JSGItems;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerActionEnum;
import tauri.dev.jsg.item.linkable.dialer.UniverseDialerMode;
import tauri.dev.jsg.sound.JSGSoundHelper;
import tauri.dev.jsg.sound.SoundEventEnum;
import tauri.dev.jsg.stargate.EnumStargateState;
import tauri.dev.jsg.tileentity.stargate.StargateUniverseBaseTile;

public class UniverseDialerActionPacketToServer
implements IMessage {
    private UniverseDialerActionEnum action;
    private EnumHand hand;
    private boolean next;

    public UniverseDialerActionPacketToServer() {
    }

    public UniverseDialerActionPacketToServer(UniverseDialerActionEnum action, EnumHand hand, boolean next) {
        this.action = action;
        this.hand = hand;
        this.next = next;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.action.ordinal());
        buf.writeInt(this.hand == EnumHand.MAIN_HAND ? 0 : 1);
        buf.writeBoolean(this.next);
    }

    public void fromBytes(ByteBuf buf) {
        this.action = UniverseDialerActionEnum.values()[buf.readInt()];
        this.hand = buf.readInt() == 0 ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND;
        this.next = buf.readBoolean();
    }

    public static class UniverseDialerActionPacketServerHandler
    implements IMessageHandler<UniverseDialerActionPacketToServer, IMessage> {
        public IMessage onMessage(UniverseDialerActionPacketToServer message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            WorldServer world = player.func_71121_q();
            world.func_152344_a(() -> {
                ItemStack stack = player.func_184586_b(message.hand);
                boolean playModeChangeSound = false;
                boolean playDialFailSound = false;
                if (stack.func_77973_b() == JSGItems.UNIVERSE_DIALER && stack.func_77942_o()) {
                    NBTTagCompound compound = stack.func_77978_p();
                    UniverseDialerMode mode = UniverseDialerMode.valueOf(compound.func_74771_c("mode"));
                    byte selected = compound.func_74771_c("selected");
                    switch (message.action) {
                        case MODE_CHANGE: {
                            mode = message.next ? mode.next() : mode.prev();
                            compound.func_74774_a("mode", mode.id);
                            compound.func_74774_a("selected", (byte)0);
                            break;
                        }
                        case ADDRESS_CHANGE: {
                            int addressCount = compound.func_150295_c(mode.tagListName, 10).func_74745_c();
                            if (message.next && selected < addressCount - 1) {
                                compound.func_74774_a("selected", (byte)(selected + 1));
                                playModeChangeSound = true;
                            }
                            if (message.next || selected <= 0) break;
                            compound.func_74774_a("selected", (byte)(selected - 1));
                            playModeChangeSound = true;
                            break;
                        }
                        case ABORT: {
                            if (compound.func_74764_b("linkedGate")) {
                                BlockPos pos = BlockPos.func_177969_a((long)compound.func_74763_f("linkedGate"));
                                StargateUniverseBaseTile gateTile = (StargateUniverseBaseTile)world.func_175625_s(pos);
                                if (gateTile == null) break;
                                if (gateTile.getStargateState() == EnumStargateState.DIALING) {
                                    if (!gateTile.abortDialingSequence()) break;
                                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.aborting", new Object[0]), true);
                                    playDialFailSound = true;
                                    break;
                                }
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.not_dialing", new Object[0]), true);
                                break;
                            }
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.not_linked", new Object[0]), true);
                            break;
                        }
                        case SET_FAST_DIAL: {
                            if (compound.func_74764_b("linkedGate")) {
                                BlockPos pos = BlockPos.func_177969_a((long)compound.func_74763_f("linkedGate"));
                                StargateUniverseBaseTile gateTile = (StargateUniverseBaseTile)world.func_175625_s(pos);
                                if (gateTile == null) break;
                                if (gateTile.getStargateState().idle()) {
                                    gateTile.setFastDial(!gateTile.getFastDialState());
                                    playModeChangeSound = true;
                                    if (gateTile.getFastDialState()) {
                                        player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.fast_dail_true", new Object[0]), true);
                                        break;
                                    }
                                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.fast_dail_false", new Object[0]), true);
                                    break;
                                }
                                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.gate_busy", new Object[0]), true);
                                break;
                            }
                            player.func_146105_b((ITextComponent)new TextComponentTranslation("item.jsg.universe_dialer.not_linked", new Object[0]), true);
                        }
                    }
                }
                if (playDialFailSound) {
                    JSGSoundHelper.playSoundToPlayer(player, SoundEventEnum.UNIVERSE_DIALER_START_DIAL, player.func_180425_c());
                }
                if (playModeChangeSound) {
                    JSGSoundHelper.playSoundToPlayer(player, SoundEventEnum.UNIVERSE_DIALER_MODE_CHANGE, player.func_180425_c());
                }
            });
            return null;
        }
    }
}

