/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.mainmenu;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiWorldSelection;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.GuiModList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.gui.element.GuiHelper;
import tauri.dev.jsg.gui.element.IconButton;
import tauri.dev.jsg.gui.mainmenu.EnumMainMenuGateType;
import tauri.dev.jsg.gui.mainmenu.EnumMainMenuTips;
import tauri.dev.jsg.gui.mainmenu.MainMenuNotifications;
import tauri.dev.jsg.loader.ReloadListener;
import tauri.dev.jsg.sound.JSGSoundHelperClient;
import tauri.dev.jsg.sound.SoundPositionedEnum;
import tauri.dev.jsg.util.JSGMinecraftHelper;
import tauri.dev.jsg.util.updater.GetUpdate;

@SideOnly(value=Side.CLIENT)
public class GuiCustomMainMenu
extends GuiScreen {
    public static final String WEBSITE = "https://justsgmod.eu/";
    public static final String GITHUB = "https://github.com/Tau-ri-Dev";
    public static final String MINECRAFT_SITES = "https://minecraft.net/en-us";
    public static final String JSG_RUNNING_TEXT = "Just Stargate Mod v" + "1.12.2-4.11.0.8".replaceAll("1.12.2-", "");
    public double tick;
    private static int bestFPS = 0;
    public static final ArrayList<ResourceLocation> BACKGROUNDS = new ArrayList<ResourceLocation>(){
        {
            this.add(new ResourceLocation("jsg", "textures/gui/mainmenu/background0.jpg"));
            this.add(new ResourceLocation("jsg", "textures/gui/mainmenu/background1.jpg"));
            this.add(new ResourceLocation("jsg", "textures/gui/mainmenu/background2.jpg"));
            this.add(new ResourceLocation("jsg", "textures/gui/mainmenu/background3.jpg"));
            this.add(new ResourceLocation("jsg", "textures/gui/mainmenu/background4.jpg"));
            this.add(new ResourceLocation("jsg", "textures/gui/mainmenu/background5.jpg"));
            this.add(new ResourceLocation("jsg", "textures/gui/mainmenu/background6.jpg"));
        }
    };
    public static final ResourceLocation LOGO_TAURI = new ResourceLocation("jsg", "textures/gui/mainmenu/tauri_dev_logo.png");
    public static final ResourceLocation LOGO_MOJANG = new ResourceLocation("jsg", "textures/gui/mainmenu/mojang_logo.png");
    public static final ResourceLocation LOGO_JSG = new ResourceLocation("jsg", "textures/gui/mainmenu/jsg_logo.png");
    private static int currentButton = 0;
    private static final int BACKGROUND_CHANGE_ANIMATION_LENGTH = 60;
    private static final int BACKGROUND_STAY_TIME = 400;
    private long backgroundChangeStart = 0L;
    public static GetUpdate.UpdateResult UPDATER_RESULT = GetUpdate.checkForUpdate();
    public static final int BACKGROUNDS_COUNT = BACKGROUNDS.size();
    public boolean isMusicPlaying = false;
    public static long menuDisplayed = -1L;
    public static boolean menuWasDisplayed = false;
    public static double firstTransitionStart = 0.0;
    public static final long FIRST_TRANSITION_LENGTH = 140L;
    public static final int PADDING = 10;
    public static final MainMenuNotifications NOTIFIER = MainMenuNotifications.getManager();
    private static int updaterNotification = -1;
    public EnumMainMenuGateType gateType = EnumMainMenuGateType.random(null);
    private long lastGateChange = 0L;
    private double backgroundScale = 1.0;
    private int currentBackground = 0;
    private EnumMainMenuTips tipEnum = EnumMainMenuTips.random(null);

    public void tick() {
        if (JSGConfig.General.mainMenuConfig.syncEnabled) {
            this.tick = JSGMinecraftHelper.getClientTickPrecise();
        } else {
            int currentFPS = Minecraft.func_175610_ah();
            if (currentFPS > bestFPS) {
                bestFPS = Math.min(currentFPS, 30);
            }
            this.tick += bestFPS > 0 ? 30.0 / (double)bestFPS * (20.0 / (double)bestFPS) : 1.0;
        }
    }

    public void createFadeIn() {
        this.backgroundChangeStart = (long)(this.tick - 20.0);
    }

    public GuiCustomMainMenu() {
        this.tick = JSGMinecraftHelper.getClientTickPrecise();
        this.createFadeIn();
    }

    public ResourceLocation getIconsTexture() {
        switch (this.gateType) {
            default: {
                return new ResourceLocation("jsg", "textures/gui/mainmenu/icons_mw.png");
            }
            case PEGASUS: {
                return new ResourceLocation("jsg", "textures/gui/mainmenu/icons_pg.png");
            }
            case UNIVERSE: 
        }
        return new ResourceLocation("jsg", "textures/gui/mainmenu/icons_uni.png");
    }

    public static void playMusic(boolean play) {
        JSGSoundHelperClient.playPositionedSoundClientSide(JSG.lastPlayerPosInWorld, SoundPositionedEnum.MAINMENU_MUSIC, play);
    }

    public void updateMusic() {
        if (this.tick - (double)menuDisplayed <= 140.0 || Minecraft.func_175610_ah() < 28 && this.tick - (double)menuDisplayed <= 600.0) {
            return;
        }
        if (this.tick - (double)menuDisplayed > 600.0) {
            this.isMusicPlaying = JSGSoundHelperClient.getRecord(SoundPositionedEnum.MAINMENU_MUSIC, JSG.lastPlayerPosInWorld).isPlaying();
        }
        if (!this.isMusicPlaying && JSGConfig.General.mainMenuConfig.playMusic) {
            this.isMusicPlaying = true;
            GuiCustomMainMenu.playMusic(true);
        }
        if (!JSGConfig.General.mainMenuConfig.playMusic && this.isMusicPlaying) {
            GuiCustomMainMenu.playMusic(false);
        }
    }

    public int[] getCenterPos(int rectWidth, int rectHeight) {
        return GuiCustomMainMenu.getCenterPos(rectWidth, rectHeight, this.field_146294_l, this.field_146295_m);
    }

    public static int[] getCenterPos(int rectWidth, int rectHeight, int winWidth, int winHeight) {
        return new int[]{(winWidth - rectWidth) / 2, (winHeight - rectHeight) / 2};
    }

    public void func_73866_w_() {
        if (JSGConfig.General.devConfig.enableDevMode) {
            UPDATER_RESULT = new GetUpdate.UpdateResult(JSGConfig.General.devConfig.t1 ? GetUpdate.EnumUpdateResult.ERROR : GetUpdate.EnumUpdateResult.NEWER_AVAILABLE, JSGConfig.General.devConfig.t1 ? "Test error" : GuiCustomMainMenu.UPDATER_RESULT.response);
            updaterNotification = -1;
        }
        if (JSGConfig.General.mainMenuConfig.debugMode) {
            menuWasDisplayed = false;
        }
        super.func_73866_w_();
        this.createFadeIn();
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        int id = -1;
        int texSize = 128;
        this.field_146292_n.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 32, 32, 32, 32, false, I18n.func_135052_a((String)"menu.singleplayer", (Object[])new Object[0])));
        this.field_146292_n.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 64, 32, 32, 32, false, I18n.func_135052_a((String)"menu.multiplayer", (Object[])new Object[0])));
        this.field_146292_n.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 32, 0, 32, 32, false, I18n.func_135052_a((String)"menu.options", (Object[])new Object[0])));
        this.field_146292_n.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 0, 32, 32, 32, false, I18n.func_135052_a((String)"menu.quit", (Object[])new Object[0])));
        this.field_146292_n.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 0, 0, 32, 32, false, I18n.func_135052_a((String)"menu.about", (Object[])new Object[0])));
        this.field_146292_n.add(new IconButton(++id, 0, 0, this.getIconsTexture(), 128, 64, 0, 32, 32, false, I18n.func_135052_a((String)"fml.menu.mods", (Object[])new Object[0])));
        this.initUpdaterNotifier();
    }

    public int getButtonForDisplay(int offset) {
        if (offset > 0) {
            return this.getNextButton(offset);
        }
        if (offset < 0) {
            return this.getPreviousButton(offset * -1);
        }
        return currentButton;
    }

    private int getNextButton(int offset) {
        return (currentButton + offset) % this.field_146292_n.size();
    }

    private int getPreviousButton(int offset) {
        int id = currentButton;
        for (int i = 0; i < offset; ++i) {
            if (--id >= 0) continue;
            id = this.field_146292_n.size() - 1;
        }
        return id;
    }

    public void updateGateType() {
        if (this.tick - (double)this.lastGateChange < 600.0) {
            return;
        }
        this.lastGateChange = (long)this.tick;
        if (JSGConfig.General.mainMenuConfig.enableGateChanging) {
            this.gateType = EnumMainMenuGateType.random(this.gateType);
        }
        this.tipEnum = EnumMainMenuTips.random(this.tipEnum);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.tick();
        if (menuDisplayed == -1L) {
            menuDisplayed = (long)this.tick;
            this.createFadeIn();
        }
        this.updateMusic();
        this.updateGateType();
        this.drawBackground();
        this.drawButtons(mouseX, mouseY);
        this.drawTitles();
        this.drawFg(mouseX, mouseY);
        if (!menuWasDisplayed) {
            firstTransitionStart = this.tick;
            if (Minecraft.func_175610_ah() >= 25) {
                menuWasDisplayed = true;
            }
        }
        this.drawFirstAnimation();
    }

    public void drawFirstAnimation() {
        if (!JSGConfig.General.mainMenuConfig.enableLogo) {
            return;
        }
        double current = this.tick - firstTransitionStart;
        if (current > 140.0) {
            return;
        }
        double step = 28.0;
        double alpha = 1.0 - Math.min(1.0, Math.max(0.0, current - 4.5 * step) / (step / 2.0));
        double alpha2 = 1.0 - Math.min(1.0, Math.max(0.0, current - step) / step);
        double coef = Math.min(1.0, Math.max(0.0, current - 4.0 * step) / (step / 2.0));
        float sizeCoefEnd = 10.0f;
        float sizeCoef = (float)Math.max(coef * 10.0, 3.0);
        int sizeXJSG = (int)((float)this.field_146294_l / sizeCoef);
        int sizeYJSG = 230 * sizeXJSG / 411;
        int sizeXMojang = (int)((float)this.field_146294_l / sizeCoef);
        int sizeYMojang = 52 * sizeXMojang / 300;
        int[] center = this.getCenterPos(sizeXJSG, sizeYJSG);
        int xEnd = 10;
        int yEnd = this.field_146295_m - 10 - sizeYJSG - sizeYMojang - 8;
        int xStart = center[0];
        int yStart = center[1];
        double xSum = xStart - xEnd;
        double ySum = yStart - yEnd;
        int x = (int)((double)xEnd + (1.0 - coef) * xSum);
        int y = (int)((double)yEnd + (1.0 - coef) * ySum);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)52.0f);
        GlStateManager.func_179094_E();
        GuiCustomMainMenu.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)new Color(0, 0, 0, (int)(255.0 * alpha)).getRGB());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LOGO_TAURI);
        GuiCustomMainMenu.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)411, (int)230, (int)sizeXJSG, (int)sizeYJSG, (float)410.0f, (float)229.0f);
        center = this.getCenterPos(0, 0);
        if (alpha > 0.75) {
            this.drawCenteredString(this.field_146289_q, "We are not associated with Mojang.", center[0], this.field_146295_m - 10 - 10, 0xFFFFFF, true);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GuiCustomMainMenu.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)new Color(0, 0, 0, (int)(255.0 * alpha2)).getRGB());
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        NOTIFIER.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0 && GuiCustomMainMenu.NOTIFIER.currentDisplayed == null) {
            for (GuiButton guibutton : this.field_146292_n) {
                if (!guibutton.func_146116_c(this.field_146297_k, mouseX, mouseY)) continue;
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
            }
            int sizeXTauri = this.field_146294_l / 10;
            int sizeYTauri = 230 * sizeXTauri / 411;
            int sizeYMojang = 52 * sizeXTauri / 300;
            if (GuiHelper.isPointInRegion(10, this.field_146295_m - 10 - sizeYTauri - sizeYMojang - 8, sizeXTauri, sizeYTauri, mouseX, mouseY)) {
                GetUpdate.openWebsiteToClient(GITHUB);
            }
            if (GuiHelper.isPointInRegion(10, this.field_146295_m - 10 - sizeYMojang, sizeXTauri, sizeYMojang, mouseX, mouseY)) {
                GetUpdate.openWebsiteToClient(MINECRAFT_SITES);
            }
            int jsgSizeX = this.field_146289_q.func_78256_a(JSG_RUNNING_TEXT);
            int jsgSizeY = 10;
            int sizeXJSG = (int)((double)this.field_146294_l / 2.33);
            int sizeYJSG = 603 * sizeXJSG / 1586;
            int[] center = this.getCenterPos(sizeXJSG, sizeYJSG);
            int x = (int)((double)center[0] * 0.25);
            int y = (int)((double)center[1] * 0.5);
            if (GuiHelper.isPointInRegion(10, 10, jsgSizeX, jsgSizeY, mouseX, mouseY) || GuiHelper.isPointInRegion(x, y, sizeXJSG, sizeYJSG, mouseX, mouseY)) {
                GetUpdate.openWebsiteToClient(WEBSITE);
            }
        }
    }

    protected void func_146284_a(@Nonnull GuiButton button) {
        if (button.field_146127_k < this.field_146292_n.size()) {
            if (button.field_146127_k != currentButton) {
                currentButton = button.field_146127_k;
                return;
            }
            switch (button.field_146127_k) {
                case 0: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldSelection((GuiScreen)this));
                    break;
                }
                case 1: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiMultiplayer((GuiScreen)this));
                    break;
                }
                case 2: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiOptions((GuiScreen)this, this.field_146297_k.field_71474_y));
                    break;
                }
                case 3: {
                    this.field_146297_k.func_71400_g();
                    break;
                }
                case 4: {
                    GetUpdate.openWebsiteToClient(WEBSITE);
                    break;
                }
                case 5: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiModList((GuiScreen)this));
                }
            }
        }
    }

    public void drawButtons(int mouseX, int mouseY) {
        for (GuiButton button : this.field_146292_n) {
            button.field_146125_m = false;
            boolean bl = button.field_146124_l = GuiCustomMainMenu.NOTIFIER.currentDisplayed == null;
            if (!(button instanceof IconButton)) continue;
            ((IconButton)button).texture = this.getIconsTexture();
        }
        for (int i = -2; i <= 2; ++i) {
            GlStateManager.func_179147_l();
            int btn = this.getButtonForDisplay(i);
            IconButton button = (IconButton)((Object)this.field_146292_n.get(btn));
            int x = this.field_146294_l - (button.field_146120_f + 20);
            int y = this.getCenterPos(button.field_146120_f, button.field_146121_g)[1] + i * (button.field_146121_g + 10);
            button.field_146128_h = x;
            button.field_146129_i = y;
            button.field_146125_m = true;
            button.drawButton(mouseX, mouseY);
            if (i == 0) {
                button.drawButton(mouseX, mouseY);
                button.drawButton(mouseX, mouseY);
                button.drawButton(mouseX, mouseY);
                String[] label = button.label;
                int labelHigh = label.length * 10;
                int syDefault = button.field_146129_i + button.field_146121_g / 2;
                int syStart = syDefault - labelHigh / 2;
                int color = 0xFFFFFF;
                for (int ii = 0; ii < label.length; ++ii) {
                    this.field_146289_q.func_78276_b(label[ii], button.field_146128_h - 5 - this.field_146289_q.func_78256_a(label[ii]), syStart + ii * 10, color);
                    color = 0x404040;
                }
            }
            if (i == -1 || i == 1) {
                button.drawButton(mouseX, mouseY);
            }
            GlStateManager.func_179084_k();
        }
    }

    public void drawBackground() {
        this.currentBackground = (int)(Math.floor(this.tick / 400.0) % (double)BACKGROUNDS_COUNT);
        double timeHere = this.tick % 400.0;
        if (timeHere > 370.0 && this.backgroundChangeStart == -1L) {
            this.backgroundChangeStart = (long)this.tick;
        }
        float scale = 1.0f + (float)(timeHere / 400.0 * (double)0.2f);
        double coef = 0.0;
        double current = this.tick - (double)this.backgroundChangeStart;
        if (this.backgroundChangeStart != -1L) {
            if (current <= 60.0) {
                coef = Math.min(Math.sin(current / 60.0 * Math.PI) * 1.1, 1.0);
            } else {
                this.backgroundChangeStart = -1L;
            }
        }
        GlStateManager.func_179094_E();
        int[] center = this.getCenterPos(0, 0);
        GlStateManager.func_179109_b((float)center[0], (float)center[1], (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        this.backgroundScale = scale;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(BACKGROUNDS.get(this.currentBackground));
        GuiCustomMainMenu.func_152125_a((int)(-(this.field_146294_l / 2)), (int)(-(this.field_146295_m / 2)), (float)0.0f, (float)0.0f, (int)1921, (int)1018, (int)this.field_146294_l, (int)this.field_146295_m, (float)1920.0f, (float)1017.0f);
        GlStateManager.func_179121_F();
        GuiCustomMainMenu.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)new Color(0, 0, 0, (int)(255.0 * coef)).getRGB());
        this.gateType.renderGate(this.field_146294_l + 20, this.getCenterPos(0, 0)[1], 45.0f, this.tick);
    }

    public void drawTitles() {
        if (JSGConfig.General.mainMenuConfig.debugMode) {
            int[] center = this.getCenterPos(0, 0);
            center[1] = center[1] - 30;
            int i = 0;
            this.field_146289_q.func_78276_b("FPS: " + Minecraft.func_175610_ah(), 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("width: " + this.field_146294_l, 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("height: " + this.field_146295_m, 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("time: " + String.format("%.4f", this.tick), 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("timeHere: " + String.format("%.4f", this.tick % 400.0), 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("backgroundScale: " + String.format("%.4f", this.backgroundScale), 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("backgroundChangeStart: " + this.backgroundChangeStart, 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("currentBackground: " + this.currentBackground, 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("gateType: " + this.gateType.toString(), 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("currentButton: " + currentButton, 10, center[1] + 10 * ++i, 0xFFFFFF);
            this.field_146289_q.func_78276_b("updater: (Status: " + GuiCustomMainMenu.UPDATER_RESULT.result.toString() + "; Got: " + GuiCustomMainMenu.UPDATER_RESULT.response + ")", 10, center[1] + 10 * ++i, 0xFFFFFF);
        }
        this.field_146289_q.func_78276_b(JSG_RUNNING_TEXT, 10, 10, 0xFFFFFF);
        this.field_146289_q.func_78276_b("Running on Minecraft Java 1.12.2", 10, 20, 0xFFFFFF);
        int sizeXTauri = this.field_146294_l / 10;
        int sizeYTauri = 230 * sizeXTauri / 411;
        int sizeXMojang = this.field_146294_l / 10;
        int sizeYMojang = 52 * sizeXMojang / 300;
        int sizeXJSG = (int)((double)this.field_146294_l / 2.33);
        int sizeYJSG = 603 * sizeXJSG / 1586;
        int[] center = this.getCenterPos(sizeXJSG, sizeYJSG);
        int x = (int)((double)center[0] * 0.25);
        int y = (int)((double)center[1] * 0.5);
        GlStateManager.func_179147_l();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LOGO_TAURI);
        GuiCustomMainMenu.func_152125_a((int)10, (int)(this.field_146295_m - 10 - sizeYTauri - sizeYMojang - 8), (float)0.0f, (float)0.0f, (int)411, (int)230, (int)sizeXTauri, (int)sizeYTauri, (float)410.0f, (float)229.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LOGO_MOJANG);
        GuiCustomMainMenu.func_152125_a((int)10, (int)(this.field_146295_m - 10 - sizeYMojang), (float)0.0f, (float)0.0f, (int)301, (int)53, (int)sizeXMojang, (int)sizeYMojang, (float)300.0f, (float)52.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(LOGO_JSG);
        GuiCustomMainMenu.func_152125_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)1586, (int)603, (int)sizeXJSG, (int)sizeYJSG, (float)1586.0f, (float)603.0f);
        String[] tip = this.tipEnum.text;
        int startY = -(tip.length * 10);
        int i = 0;
        center = this.getCenterPos(0, 0);
        for (String s : tip) {
            this.drawCenteredString(this.field_146289_q, I18n.func_135052_a((String)s, (Object[])new Object[0]), center[0], this.field_146295_m - 10 + startY + i * 10, 13544744, true);
            ++i;
        }
        GlStateManager.func_179084_k();
    }

    public void drawFg(int mouseX, int mouseY) {
        NOTIFIER.update();
        if (GuiCustomMainMenu.NOTIFIER.currentDisplayed == null) {
            for (GuiButton b : this.field_146292_n) {
                if (!(b instanceof IconButton) || !b.field_146125_m || b.field_146127_k == currentButton) continue;
                ((IconButton)b).drawFg(mouseX, mouseY, this);
            }
            int sizeXTauri = this.field_146294_l / 10;
            int sizeYTauri = 230 * sizeXTauri / 411;
            int sizeYMojang = 52 * sizeXTauri / 300;
            if (GuiHelper.isPointInRegion(10, this.field_146295_m - 10 - sizeYTauri - sizeYMojang - 8, sizeXTauri, sizeYTauri, mouseX, mouseY)) {
                List<String> power = Arrays.asList(TextFormatting.WHITE.toString() + TextFormatting.BOLD + "Just Stargate Mod developed by:", TextFormatting.GRAY + "MineDragonCZ_", TextFormatting.GRAY + "matousss", TextFormatting.GRAY + "Fredyman_95", TextFormatting.GRAY + "Harald De Luca", TextFormatting.GRAY + "", TextFormatting.WHITE.toString() + TextFormatting.BOLD + "Base of this mod by:", TextFormatting.GRAY + "MrJake222");
                this.func_146283_a(power, mouseX, mouseY);
            }
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
            this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1072689136, -804253680);
            NOTIFIER.render(mouseX, mouseY, this.field_146294_l, this.field_146295_m, this);
            GlStateManager.func_179121_F();
        }
    }

    public void drawCenteredString(FontRenderer fontRendererIn, @Nonnull String text, int x, int y, int color, boolean shadow) {
        if (shadow) {
            super.func_73732_a(fontRendererIn, text, x, y, color);
            return;
        }
        fontRendererIn.func_78276_b(text, x - fontRendererIn.func_78256_a(text) / 2, y, color);
    }

    public void initUpdaterNotifier() {
        if (GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.NEWER_AVAILABLE || GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.ERROR) {
            boolean error;
            boolean bl = error = GuiCustomMainMenu.UPDATER_RESULT.result == GetUpdate.EnumUpdateResult.ERROR;
            if (updaterNotification == -1 || NOTIFIER.get(updaterNotification) == null) {
                updaterNotification = !error ? NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<GuiButton>(){
                    {
                        String update = I18n.func_135052_a((String)"menu.updater.download", (Object[])new Object[0]);
                        int width = GuiCustomMainMenu.this.field_146289_q.func_78256_a(update) + 20;
                        this.add(new GuiButton(40, -width - 5, 0, width, 20, update));
                        update = I18n.func_135052_a((String)"menu.updater.close", (Object[])new Object[0]);
                        width = GuiCustomMainMenu.this.field_146289_q.func_78256_a(update) + 20;
                        this.add(new GuiButton(41, 5, 0, width, 20, update));
                    }
                }, new String[]{"New update is available!", "", "", "You can update to version " + GuiCustomMainMenu.UPDATER_RESULT.response, "It is highly recommended to update to this version!", "Some dangerous bugs should be fixed in this version."}){

                    @Override
                    public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, GuiScreen parentScreen) {
                        super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                        int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                        ((GuiButton)this.buttons.get((int)0)).field_146129_i = rectY + 140 - 30;
                        ((GuiButton)this.buttons.get((int)0)).field_146128_h = xCenter - ((GuiButton)this.buttons.get((int)0)).field_146120_f - 5;
                        ((GuiButton)this.buttons.get(0)).func_191745_a(GuiCustomMainMenu.this.field_146297_k, mouseX, mouseY, 0.0f);
                        ((GuiButton)this.buttons.get((int)1)).field_146128_h = xCenter + 5;
                        ((GuiButton)this.buttons.get((int)1)).field_146129_i = ((GuiButton)this.buttons.get((int)0)).field_146129_i;
                        ((GuiButton)this.buttons.get(1)).func_191745_a(GuiCustomMainMenu.this.field_146297_k, mouseX, mouseY, 0.0f);
                    }

                    @Override
                    public void actionPerformed(@Nonnull GuiButton button) {
                        switch (button.field_146127_k) {
                            case 40: {
                                GetUpdate.openWebsiteToClient(GetUpdate.DOWNLOAD_URL_USER);
                                break;
                            }
                            case 41: {
                                this.dismiss();
                                break;
                            }
                        }
                    }
                }) : NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<GuiButton>(){
                    {
                        String close = I18n.func_135052_a((String)"menu.updater.close", (Object[])new Object[0]);
                        int width = GuiCustomMainMenu.this.field_146289_q.func_78256_a(close) + 20;
                        this.add(new GuiButton(41, -width / 2, 0, width, 20, close));
                    }
                }, new String[]{"Error while checking update!", GuiCustomMainMenu.UPDATER_RESULT.response, "", "Can not get response from the server!", "Please check your internet connection."}){

                    @Override
                    public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, GuiScreen parentScreen) {
                        super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                        int xCenter = GuiCustomMainMenu.this.getCenterPos(0, 0)[0];
                        ((GuiButton)this.buttons.get((int)0)).field_146129_i = rectY + 140 - 30;
                        ((GuiButton)this.buttons.get((int)0)).field_146128_h = xCenter - ((GuiButton)this.buttons.get((int)0)).field_146120_f / 2;
                        ((GuiButton)this.buttons.get(0)).func_191745_a(GuiCustomMainMenu.this.field_146297_k, mouseX, mouseY, 0.0f);
                    }

                    @Override
                    public void actionPerformed(@Nonnull GuiButton button) {
                        if (button.field_146127_k == 41) {
                            this.dismiss();
                        }
                    }
                });
            }
        }
    }

    static {
        if (JSGConfig.General.mainMenuConfig.debugMode) {
            NOTIFIER.add(new MainMenuNotifications.Notification(new ArrayList<GuiButton>(){
                {
                    String close = I18n.func_135052_a((String)"menu.updater.close", (Object[])new Object[0]);
                    int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(close) + 20;
                    this.add(new GuiButton(41, -width / 2, 0, width, 20, close));
                }
            }, new String[]{"Report from startup:", "", "Total errors/warning: " + ReloadListener.LoadingStats.errors + "/" + ReloadListener.LoadingStats.warnings, "Total textures loaded/not: " + ReloadListener.LoadingStats.loadedTextures + "/" + ReloadListener.LoadingStats.notLoadedTextures, "Total models loaded/not: " + ReloadListener.LoadingStats.loadedModels + "/" + ReloadListener.LoadingStats.notLoadedModels, "Loaded animated EH: " + ReloadListener.LoadingStats.loadedAnimatedEHs, "Loaded new kawoosh: " + ReloadListener.LoadingStats.loadedNewKawoosh}){

                @Override
                public void render(int mouseX, int mouseY, int width, int height, int rectX, int rectY, GuiScreen parentScreen) {
                    super.renderText(mouseX, mouseY, width, height, rectX, rectY, parentScreen);
                    int xCenter = GuiCustomMainMenu.getCenterPos(0, 0, width, height)[0];
                    ((GuiButton)this.buttons.get((int)0)).field_146129_i = rectY + 140 - 30;
                    ((GuiButton)this.buttons.get((int)0)).field_146128_h = xCenter - ((GuiButton)this.buttons.get((int)0)).field_146120_f / 2;
                    ((GuiButton)this.buttons.get(0)).func_191745_a(parentScreen.field_146297_k, mouseX, mouseY, 0.0f);
                }

                @Override
                public void actionPerformed(@Nonnull GuiButton button) {
                    if (button.field_146127_k == 41) {
                        this.dismiss();
                    }
                }
            });
        }
    }
}

