/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.entry;

import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.client.config.GuiUtils;
import tauri.dev.jsg.gui.base.JSGButton;
import tauri.dev.jsg.gui.element.ArrowButton;
import tauri.dev.jsg.gui.entry.AbstractAddressEntry;
import tauri.dev.jsg.gui.entry.AbstractEntry;
import tauri.dev.jsg.packet.gui.entry.EntryActionEnum;
import tauri.dev.jsg.packet.gui.entry.EntryDataTypeEnum;
import tauri.dev.jsg.stargate.network.StargateAddress;
import tauri.dev.jsg.stargate.network.SymbolInterface;
import tauri.dev.jsg.stargate.network.SymbolTypeEnum;

public class UniverseEntry
extends AbstractAddressEntry {
    public static final int ADDRESS_WIDTH = 80;
    public static final int BUTTON_COUNT = 4;
    public JSGButton dialButton = new ArrowButton(150, 0, 0, ArrowButton.ArrowType.RIGHT).setFgColor(GuiUtils.getColorCode((char)'a', (boolean)true)).setActionCallback(() -> this.action(EntryActionEnum.DIAL));

    public UniverseEntry(Minecraft mc, int index, int maxIndex, EnumHand hand, String name, AbstractEntry.ActionListener reloadListener, SymbolTypeEnum type, StargateAddress addr, int maxSymbols) {
        super(mc, index, maxIndex, hand, name, reloadListener, type, null, addr, null, maxSymbols);
        this.buttons.add(this.dialButton);
    }

    @Override
    public void renderAt(int dx, int dy, int mouseX, int mouseY, float partialTicks) {
        int width = 15;
        int height = 30;
        int xSpacing = 10;
        int addressWidth = 10 * this.maxSymbols + 5;
        int x = dx + (80 - addressWidth) / 2;
        for (int i = 0; i < this.maxSymbols && this.stargateAddress != null; ++i) {
            SymbolInterface symbol = this.stargateAddress.get(i);
            this.renderSymbol(x, dy, 15, 30, mouseX, mouseY, symbol);
            x += 10;
        }
        super.renderAt(dx + 80 + 10, dy + 5, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getHeight() {
        return 30;
    }

    @Override
    protected int getMaxNameLength() {
        return 16;
    }

    @Override
    protected EntryDataTypeEnum getEntryDataType() {
        return EntryDataTypeEnum.UNIVERSE;
    }
}

