/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.zpmhub;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import tauri.dev.jsg.capability.CapabilityEnergyZPM;
import tauri.dev.jsg.gui.container.zpmhub.ZPMHubContainer;
import tauri.dev.jsg.gui.element.BetterButton;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.ZPMHubAnimationToServer;
import tauri.dev.jsg.power.zpm.IEnergyStorageZPM;

public class ZPMHubContainerGui
extends GuiContainer {
    protected final ZPMHubContainer container;
    protected BetterButton button;
    private boolean error = false;

    public ResourceLocation getBackground() {
        return new ResourceLocation("jsg", "textures/gui/container_zpmhub.png");
    }

    public String getGuiUnlocalizedName() {
        return "tile.jsg.zpm_hub_block.name";
    }

    public ZPMHubContainerGui(ZPMHubContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 179;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.button = new BetterButton(0, 9 + this.field_147003_i, 51 + this.field_147009_r, 16, this.getBackground(), 256, 256, 176, 0);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(this.getBackground());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        long energyStored = 0L;
        long maxEnergyStored = 0L;
        for (int i = 0; i < 3; ++i) {
            IEnergyStorageZPM energyStorage = (IEnergyStorageZPM)this.container.func_75139_a(i).func_75211_c().getCapability(CapabilityEnergyZPM.ENERGY, null);
            if (energyStorage == null) continue;
            energyStored += energyStorage.getEnergyStored();
            maxEnergyStored += energyStorage.getMaxEnergyStored();
        }
        int width = Math.round((float)energyStored / (float)maxEnergyStored * 156.0f);
        if (maxEnergyStored == 0L) {
            width = 0;
        }
        this.renderPowerBar(width);
        this.error = this.container.hubTile.isAnimating;
        this.button.setEnabled(!this.error);
        this.button.drawButton(mouseX, mouseY);
        if (!this.container.hubTile.isSlidingUp) {
            this.error = true;
        }
        if (this.error) {
            GlStateManager.func_179147_l();
            this.func_73729_b(this.button.field_146128_h + 7, this.button.field_146129_i + 6, 176, 16, 16, 16);
            GlStateManager.func_179084_k();
        }
    }

    public void renderPowerBar(int width) {
        this.func_73733_a(this.field_147003_i + 10, this.field_147009_r + 75, this.field_147003_i + 10 + width, this.field_147009_r + 75 + 6, -3397592, -9234922);
    }

    public void renderPowerText(String energyPercent) {
        this.field_146289_q.func_78276_b(energyPercent, this.field_146999_f - 8 - this.field_146289_q.func_78256_a(energyPercent), 85, 0x404040);
    }

    public void renderHoverTexts(int mouseX, int mouseY, long energyStored, long maxEnergyStored) {
        long transferred = this.container.hubTile.getEnergyTransferedLastTick();
        TextFormatting transferredFormatting = TextFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0L) {
            transferredFormatting = TextFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0L) {
            transferredFormatting = TextFormatting.RED;
        }
        if (this.func_146978_c(10, 75, 156, 6, mouseX, mouseY)) {
            List<String> power = Arrays.asList(I18n.func_135052_a((String)"gui.stargate.energyBuffer", (Object[])new Object[0]), TextFormatting.GRAY + String.format("%,d / %,d RF", energyStored, maxEnergyStored), transferredFormatting + transferredSign + String.format("%,d RF/t", transferred));
            this.func_146283_a(power, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        List<String> s;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)this.getGuiUnlocalizedName(), (Object[])new Object[0]), 8, 16, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        long energyStored = 0L;
        long maxEnergyStored = 0L;
        for (int i = 0; i < this.container.hubTile.getContainerSize(); ++i) {
            IEnergyStorageZPM energyStorage = (IEnergyStorageZPM)this.container.func_75139_a(i).func_75211_c().getCapability(CapabilityEnergyZPM.ENERGY, null);
            if (energyStorage == null) continue;
            energyStored += energyStorage.getEnergyStored();
            maxEnergyStored += energyStorage.getMaxEnergyStored();
        }
        String energyPercent = String.format("%.2f", Float.valueOf(maxEnergyStored != 0L ? (float)energyStored / (float)maxEnergyStored * 100.0f : 0.0f)) + " %";
        this.renderPowerText(energyPercent);
        this.renderHoverTexts(mouseX, mouseY, energyStored, maxEnergyStored);
        if (this.error && this.func_146978_c(this.button.field_146128_h - this.field_147003_i + 9, this.button.field_146129_i - this.field_147009_r + 9, 16, 16, mouseX, mouseY)) {
            s = Collections.singletonList(I18n.func_135052_a((String)"gui.zpmhub.alert", (Object[])new Object[0]));
            this.func_146283_a(s, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        } else if (this.func_146978_c(this.button.field_146128_h - this.field_147003_i, this.button.field_146129_i - this.field_147009_r, 16, 16, mouseX, mouseY)) {
            s = Collections.singletonList(this.container.hubTile.isAnimating ? I18n.func_135052_a((String)"gui.zpmhub.inProgress", (Object[])new Object[0]) : (this.container.hubTile.isSlidingUp ? I18n.func_135052_a((String)"gui.zpmhub.slideDown", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.zpmhub.slideUp", (Object[])new Object[0])));
            this.func_146283_a(s, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.button.isMouseOnButton(mouseX, mouseY)) {
            this.startAnimation();
            this.button.func_146113_a(Minecraft.func_71410_x().func_147118_V());
        }
    }

    public void startAnimation() {
        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new ZPMHubAnimationToServer(this.container.hubTile.func_174877_v()));
    }
}

