/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.transportrings;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.SlotItemHandler;
import org.lwjgl.input.Mouse;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.gui.container.stargate.StargateContainerGui;
import tauri.dev.jsg.gui.container.transportrings.TRContainer;
import tauri.dev.jsg.gui.element.tabs.Tab;
import tauri.dev.jsg.gui.element.tabs.TabConfig;
import tauri.dev.jsg.gui.element.tabs.TabScrollAble;
import tauri.dev.jsg.gui.element.tabs.TabSideEnum;
import tauri.dev.jsg.gui.element.tabs.TabTRAddress;
import tauri.dev.jsg.gui.element.tabs.TabTRSettings;
import tauri.dev.jsg.gui.element.tabs.TabbedContainerInterface;
import tauri.dev.jsg.packet.JSGPacketHandler;
import tauri.dev.jsg.packet.SetOpenTabToServer;
import tauri.dev.jsg.packet.stargate.SaveConfigToServer;
import tauri.dev.jsg.packet.transportrings.SaveRingsParametersToServer;
import tauri.dev.jsg.power.stargate.StargateClassicEnergyStorage;
import tauri.dev.jsg.tileentity.transportrings.TransportRingsAbstractTile;
import tauri.dev.jsg.transportrings.SymbolTypeTransportRingsEnum;

public class TRGui
extends GuiContainer
implements TabbedContainerInterface {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_transportrings.png");
    private final TRContainer container;
    private List<Tab> tabs;
    private TabTRAddress goauldAddressTab;
    private TabTRAddress oriAddressTab;
    private TabTRAddress ancientAddressTab;
    private TabConfig configTab;
    private TabTRSettings settingsTab;
    private int energyStored;
    private int maxEnergyStored;
    private final BlockPos pos;

    public TRGui(BlockPos pos, TRContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 173;
        this.pos = pos;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabs = new ArrayList<Tab>();
        this.goauldAddressTab = (TabTRAddress)TabTRAddress.builder().setTile(this.container.trTile).setSymbolType(SymbolTypeTransportRingsEnum.GOAULD).setProgressColor(15313210).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 11).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.transportrings.goauld_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 22).build();
        this.oriAddressTab = (TabTRAddress)TabTRAddress.builder().setTile(this.container.trTile).setSymbolType(SymbolTypeTransportRingsEnum.ORI).setProgressColor(9494777).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 33).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.transportrings.ori_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 44).build();
        this.ancientAddressTab = (TabTRAddress)TabTRAddress.builder().setTile(this.container.trTile).setSymbolType(SymbolTypeTransportRingsEnum.ANCIENT).setProgressColor(9494777).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(-21, 55).setOpenX(-128).setHiddenX(-6).setTabSize(128, 113).setTabTitle(I18n.func_135052_a((String)"gui.transportrings.ancient_address", (Object[])new Object[0])).setTabSide(TabSideEnum.LEFT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 0).setIconRenderPos(0, 6).setIconSize(22, 22).setIconTextureLocation(304, 66).build();
        this.settingsTab = (TabTRSettings)TabTRSettings.builder().setParams(this.container.trTile.getRingsName(), this.container.trTile.getRingsDistance()).setGuiSize(this.field_146999_f, this.field_147000_g).setGuiPosition(this.field_147003_i, this.field_147009_r).setTabPosition(69, 2).setOpenX(176).setHiddenX(54).setTabSize(128, 68).setTabTitle(I18n.func_135052_a((String)"gui.transportrings.parameters", (Object[])new Object[0])).setTabSide(TabSideEnum.RIGHT).setTexture(BACKGROUND_TEXTURE, 512).setBackgroundTextureLocation(176, 113).setIconRenderPos(107, 5).setIconSize(22, 22).setIconTextureLocation(304, 0).build();
        this.configTab = StargateContainerGui.createConfigTab(this.container.trTile.getConfig(), this.field_146999_f, this.field_147000_g, this.field_147003_i, this.field_147009_r);
        this.tabs.add(this.goauldAddressTab);
        this.tabs.add(this.oriAddressTab);
        this.tabs.add(this.ancientAddressTab);
        this.tabs.add(this.settingsTab);
        this.tabs.add(this.configTab);
        this.configTab.setOnTabClose(this::saveConfig);
        this.configTab.setVisible(this.container.isOperator);
        this.container.field_75151_b.set(7, this.goauldAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(7)));
        this.container.field_75151_b.set(8, this.oriAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(8)));
        this.container.field_75151_b.set(9, this.ancientAddressTab.createSlot((SlotItemHandler)this.container.func_75139_a(9)));
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.settingsTab.setParams(this.container.trTile.getRingsName(), this.container.trTile.getRingsDistance());
        this.func_146276_q_();
        boolean hasGoauldUpgrade = false;
        boolean hasOriUpgrade = false;
        boolean hasAncientUpgrade = false;
        block5: for (int i2 = 0; i2 < 4; ++i2) {
            TransportRingsAbstractTile.TransportRingsUpgradeEnum upgrade;
            ItemStack itemStack = this.container.func_75139_a(i2).func_75211_c();
            if (itemStack.func_190926_b() || (upgrade = TransportRingsAbstractTile.TransportRingsUpgradeEnum.valueOf(itemStack.func_77973_b())) == null) continue;
            switch (upgrade) {
                case GOAULD_UPGRADE: {
                    hasGoauldUpgrade = true;
                    continue block5;
                }
                case ORI_UPGRADE: {
                    hasOriUpgrade = true;
                    continue block5;
                }
                case ANCIENT_UPGRADE: {
                    hasAncientUpgrade = true;
                }
            }
        }
        this.goauldAddressTab.setVisible(hasGoauldUpgrade);
        this.oriAddressTab.setVisible(hasOriUpgrade);
        this.ancientAddressTab.setVisible(hasAncientUpgrade);
        Tab.updatePositions(this.tabs);
        StargateClassicEnergyStorage energyStorageInternal = (StargateClassicEnergyStorage)((Object)this.container.trTile.getCapability(CapabilityEnergy.ENERGY, null));
        this.energyStored = Objects.requireNonNull(energyStorageInternal).getEnergyStoredInternally();
        this.maxEnergyStored = energyStorageInternal.getMaxEnergyStoredInternally();
        for (i = 4; i < 7; ++i) {
            IEnergyStorage energyStorage = (IEnergyStorage)this.container.func_75139_a(i).func_75211_c().getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage == null) continue;
            this.energyStored += energyStorage.getEnergyStored();
            this.maxEnergyStored += energyStorage.getMaxEnergyStored();
        }
        for (i = 7; i < this.container.trTile.getSlotsCount(); ++i) {
            ((Tab.SlotTab)this.container.func_75139_a(i)).updatePos();
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int i;
        if (this.container.trTile.getConfig().getOptions().size() != this.configTab.getConfig(false).getOptions().size()) {
            this.configTab.updateConfig(this.container.trTile.getConfig(), true);
        }
        for (Tab tab : this.tabs) {
            tab.render(this.field_146289_q, mouseX, mouseY);
        }
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TRGui.func_146110_a((int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)this.field_147000_g, (float)512.0f, (float)512.0f);
        for (i = 0; i < 3 - this.container.trTile.getSupportedCapacitors(); ++i) {
            TRGui.func_146110_a((int)(this.field_147003_i + 151 - 18 * i), (int)(this.field_147009_r + 27), (float)24.0f, (float)180.0f, (int)16, (int)16, (float)512.0f, (float)512.0f);
        }
        for (i = this.container.trTile.getPowerTier(); i < 4; ++i) {
            TRGui.func_146110_a((int)(this.field_147003_i + 10 + 39 * i), (int)(this.field_147009_r + 69), (float)0.0f, (float)173.0f, (int)39, (int)6, (float)512.0f, (float)512.0f);
        }
        int width = Math.round((float)this.energyStored / (float)JSGConfig.Stargate.power.stargateEnergyStorage * 156.0f);
        this.func_73733_a(this.field_147003_i + 10, this.field_147009_r + 69, this.field_147003_i + 10 + width, this.field_147009_r + 69 + 6, -3397592, -9234922);
        switch (this.container.trTile.getSymbolType()) {
            case GOAULD: {
                TRGui.func_146110_a((int)(this.field_147003_i + 136), (int)(this.field_147009_r + 4), (float)330.0f, (float)0.0f, (int)35, (int)8, (float)512.0f, (float)512.0f);
                break;
            }
            case ORI: {
                TRGui.func_146110_a((int)(this.field_147003_i + 136), (int)(this.field_147009_r + 4), (float)330.0f, (float)18.0f, (int)35, (int)8, (float)512.0f, (float)512.0f);
                break;
            }
            case ANCIENT: {
                TRGui.func_146110_a((int)(this.field_147003_i + 136), (int)(this.field_147009_r + 4), (float)330.0f, (float)36.0f, (int)35, (int)8, (float)512.0f, (float)512.0f);
                break;
            }
        }
        boolean drawICFirstCable = false;
        boolean drawICSecondCable = false;
        block17: for (int i2 = 0; i2 < 7; ++i2) {
            if (!this.container.func_75139_a(i2).func_75216_d()) continue;
            if (i2 < 4) {
                drawICFirstCable = true;
            }
            switch (i2) {
                case 0: {
                    TRGui.func_146110_a((int)(this.field_147003_i + 16), (int)(this.field_147009_r + 44), (float)11.0f, (float)239.0f, (int)22, (int)16, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 1: {
                    TRGui.func_146110_a((int)(this.field_147003_i + 34), (int)(this.field_147009_r + 44), (float)7.0f, (float)237.0f, (int)4, (int)10, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 2: {
                    TRGui.func_146110_a((int)(this.field_147003_i + 50), (int)(this.field_147009_r + 44), (float)2.0f, (float)237.0f, (int)4, (int)10, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 3: {
                    drawICSecondCable = true;
                    TRGui.func_146110_a((int)(this.field_147003_i + 50), (int)(this.field_147009_r + 44), (float)0.0f, (float)255.0f, (int)22, (int)16, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 4: {
                    TRGui.func_146110_a((int)(this.field_147003_i + 121), (int)(this.field_147009_r + 44), (float)0.0f, (float)225.0f, (int)14, (int)12, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 5: {
                    TRGui.func_146110_a((int)(this.field_147003_i + 139), (int)(this.field_147009_r + 44), (float)14.0f, (float)225.0f, (int)4, (int)6, (float)512.0f, (float)512.0f);
                    continue block17;
                }
                case 6: {
                    TRGui.func_146110_a((int)(this.field_147003_i + 147), (int)(this.field_147009_r + 44), (float)18.0f, (float)225.0f, (int)14, (int)14, (float)512.0f, (float)512.0f);
                    continue block17;
                }
            }
        }
        if (drawICFirstCable) {
            TRGui.func_146110_a((int)(this.field_147003_i + 41), (int)(this.field_147009_r + 62), (float)0.0f, (float)239.0f, (int)2, (int)6, (float)512.0f, (float)512.0f);
        }
        if (drawICSecondCable) {
            TRGui.func_146110_a((int)(this.field_147003_i + 45), (int)(this.field_147009_r + 62), (float)0.0f, (float)239.0f, (int)2, (int)6, (float)512.0f, (float)512.0f);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String caps = I18n.func_135052_a((String)"gui.stargate.capacitors", (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(caps, this.field_146999_f - 8 - this.field_146289_q.func_78256_a(caps), 16, 0x404040);
        String energyPercent = String.format("%.2f", Float.valueOf((float)this.energyStored / (float)this.maxEnergyStored * 100.0f)) + " %";
        this.field_146289_q.func_78276_b(energyPercent, this.field_146999_f - 8 - this.field_146289_q.func_78256_a(energyPercent), 79, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.upgrades", (Object[])new Object[0]), 8, 16, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        for (Tab tab : this.tabs) {
            tab.renderFg((GuiScreen)this, this.field_146289_q, mouseX, mouseY);
        }
        int transferred = this.container.trTile.getEnergyTransferedLastTick();
        TextFormatting transferredFormatting = TextFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = TextFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = TextFormatting.RED;
        }
        if (this.func_146978_c(10, 69, 156, 6, mouseX, mouseY)) {
            List<String> power = Arrays.asList(I18n.func_135052_a((String)"gui.transportrings.energyBuffer", (Object[])new Object[0]), TextFormatting.GRAY + String.format("%,d / %,d RF", this.energyStored, this.maxEnergyStored), transferredFormatting + transferredSign + String.format("%,d RF/t", transferred));
            this.func_146283_a(power, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (int i = 0; i < this.tabs.size(); ++i) {
            Tab tab = this.tabs.get(i);
            if (!tab.isCursorOnTab(mouseX, mouseY)) continue;
            if (Tab.tabsInteract(this.tabs, i)) {
                this.container.setOpenTabId(i);
            } else {
                this.container.setOpenTabId(-1);
            }
            JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SetOpenTabToServer(this.container.getOpenTabId()));
            break;
        }
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible()) continue;
            tab.mouseClicked(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel != 0) {
            for (Tab tab : this.tabs) {
                if (!(tab instanceof TabScrollAble) || !tab.isVisible() || !tab.isOpen()) continue;
                ((TabScrollAble)tab).scroll(wheel);
            }
        }
    }

    @Override
    public List<Rectangle> getGuiExtraAreas() {
        return this.tabs.stream().map(Tab::getArea).collect(Collectors.toList());
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean typed = false;
        for (Tab tab : this.tabs) {
            if (!tab.isOpen() || !tab.isVisible() || !tab.keyTyped(typedChar, keyCode)) continue;
            typed = true;
        }
        if (!typed || keyCode == 1) {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (Tab t : this.tabs) {
            t.updateScreen();
        }
    }

    public void func_146281_b() {
        this.saveData();
        this.saveConfig();
        super.func_146281_b();
    }

    private void saveConfig() {
        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SaveConfigToServer(this.pos, this.configTab.config));
        this.container.trTile.setConfig(this.configTab.getConfig(true));
    }

    public void saveData() {
        block5: {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            try {
                String name = this.settingsTab.nameTextField.func_146179_b();
                try {
                    int distance = Integer.parseInt(this.settingsTab.distanceTextField.func_146179_b());
                    if (distance >= -15 && distance <= 15) {
                        JSGPacketHandler.INSTANCE.sendToServer((IMessage)new SaveRingsParametersToServer(this.pos, name, distance));
                        this.container.trTile.setRingsParams(name, distance);
                        break block5;
                    }
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.transportrings_block.wrong_distance", new Object[0]), true);
                }
                catch (NumberFormatException e) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.transportrings_block.wrong_distance", new Object[0]), true);
                }
            }
            catch (NumberFormatException e) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.jsg.transportrings_block.wrong_address", new Object[0]), true);
            }
        }
    }
}

