/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.gui.container.capacitor;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.energy.CapabilityEnergy;
import tauri.dev.jsg.config.JSGConfig;
import tauri.dev.jsg.gui.container.capacitor.CapacitorContainer;
import tauri.dev.jsg.power.stargate.StargateAbstractEnergyStorage;

public class CapacitorContainerGui
extends GuiContainer {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("jsg", "textures/gui/container_capacitor.png");
    private final CapacitorContainer container;

    public CapacitorContainerGui(CapacitorContainer container) {
        super((Container)container);
        this.container = container;
        this.field_146999_f = 176;
        this.field_147000_g = 163;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.container.capTile.getCapability(CapabilityEnergy.ENERGY, null));
        int width = Math.round((float)Objects.requireNonNull(energyStorage).getEnergyStored() / ((float)JSGConfig.Stargate.power.stargateEnergyStorage / 4.0f) * 156.0f);
        this.func_73733_a(this.field_147003_i + 10, this.field_147009_r + 59, this.field_147003_i + 10 + width, this.field_147009_r + 59 + 6, -3397592, -9234922);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.capacitor.name", (Object[])new Object[0]), 8, 16, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.inventory", (Object[])new Object[0]), 8, this.field_147000_g - 96 + 2, 0x404040);
        StargateAbstractEnergyStorage energyStorage = (StargateAbstractEnergyStorage)((Object)this.container.capTile.getCapability(CapabilityEnergy.ENERGY, null));
        int energyStored = Objects.requireNonNull(energyStorage).getEnergyStored();
        int maxEnergyStored = energyStorage.getMaxEnergyStored();
        String energyPercent = String.format("%.2f", Float.valueOf((float)energyStored / (float)maxEnergyStored * 100.0f)) + " %";
        this.field_146289_q.func_78276_b(energyPercent, this.field_146999_f - 8 - this.field_146289_q.func_78256_a(energyPercent), 69, 0x404040);
        int transferred = this.container.capTile.getEnergyTransferedLastTick();
        TextFormatting transferredFormatting = TextFormatting.GRAY;
        String transferredSign = "";
        if (transferred > 0) {
            transferredFormatting = TextFormatting.GREEN;
            transferredSign = "+";
        } else if (transferred < 0) {
            transferredFormatting = TextFormatting.RED;
        }
        if (this.func_146978_c(10, 59, 156, 6, mouseX, mouseY)) {
            List<String> power = Arrays.asList(I18n.func_135052_a((String)"gui.stargate.energyBuffer", (Object[])new Object[0]), TextFormatting.GRAY + String.format("%,d / %,d RF", energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored()), transferredFormatting + transferredSign + String.format("%,d RF/t", transferred));
            this.func_146283_a(power, mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
    }
}

