/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.entity;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.item.tools.EnergyWeapon;

public class JSGEnergyProjectile
extends EntitySmallFireball {
    public int maxAliveTime = 10;
    public float damage = 1.0f;
    public boolean igniteGround = false;
    public boolean paralyze = false;
    public boolean explode = false;
    public boolean instaKill = false;
    public boolean invisible = false;
    public DamageSource damageSource = null;
    public int explosionPower = 1;
    private int ticksAlive;

    public JSGEnergyProjectile(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ, EnergyWeapon itemIn) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        itemIn.setEnergyBallParams(this);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + 1.5, shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.invisible) {
            this.func_82142_c(true);
        }
        this.ticksAlive = 0;
    }

    public void setSize(float size) {
        this.func_70105_a(size, size);
    }

    public static JSGEnergyProjectile createEnergyBall(World worldIn, EntityLivingBase shooter, EnergyWeapon itemIn) {
        Vec3d vector = shooter.func_70040_Z();
        return new JSGEnergyProjectile(worldIn, shooter, vector.field_72450_a * 100.0, vector.field_72448_b * 100.0, vector.field_72449_c * 100.0, itemIn);
    }

    public static JSGEnergyProjectile createEnergyBall(World worldIn, EntityLivingBase shooter, EntityLivingBase target, EnergyWeapon itemIn) {
        double d0 = target.field_70163_u + (double)target.func_70047_e() - 2.100000023841858;
        double d1 = target.field_70165_t - shooter.field_70165_t;
        double d2 = d0 - (shooter.field_70163_u + 1.0);
        double d3 = target.field_70161_v - shooter.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3)) * 0.2f;
        return new JSGEnergyProjectile(worldIn, shooter, d1 * 100.0, (d2 + (double)f) * 100.0, d3 * 100.0, itemIn);
    }

    protected boolean func_184564_k() {
        return this.igniteGround;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        if (this.invisible) {
            return false;
        }
        return super.func_70112_a(distance);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.ticksAlive;
        if (this.ticksAlive > this.maxAliveTime) {
            this.func_70106_y();
        }
    }

    @ParametersAreNonnullByDefault
    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.damageSource != null) {
                if (result.field_72308_g != null) {
                    Entity entity = result.field_72308_g;
                    boolean flag = entity.func_70097_a(this.damageSource, this.damage);
                    if (entity instanceof EntityItem) {
                        entity.func_70106_y();
                    }
                    if (flag) {
                        this.func_174815_a(this.field_70235_a, entity);
                        if (this.paralyze && entity instanceof EntityLivingBase) {
                            EntityLivingBase e = (EntityLivingBase)entity;
                            if (e.func_70644_a(MobEffects.field_76421_d) && e.func_70644_a(MobEffects.field_76437_t)) {
                                e.func_70097_a(this.damageSource, Float.MAX_VALUE);
                            } else {
                                e.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100));
                                e.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100));
                                e.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60));
                            }
                        }
                        if (this.instaKill && !entity.field_70128_L) {
                            entity.func_70097_a(this.damageSource, Float.MAX_VALUE);
                        }
                        if (this.igniteGround || this.explode) {
                            entity.func_70015_d(5);
                        }
                    }
                } else {
                    BlockPos blockpos;
                    if (this.igniteGround && this.field_70170_p.func_175623_d(blockpos = result.func_178782_a().func_177972_a(result.field_178784_b))) {
                        this.field_70170_p.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                    }
                    if (this.explode) {
                        this.field_70170_p.func_72885_a((Entity)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (float)this.explosionPower, this.igniteGround, true);
                    }
                }
            }
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ExplosionPower", this.explosionPower);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ExplosionPower", 99)) {
            this.explosionPower = compound.func_74762_e("ExplosionPower");
        }
    }
}

