/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config.structures;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class StructureConfig {
    private final Map<String, StructureConfigEntry> entries = new HashMap<String, StructureConfigEntry>();
    private final String configId;
    private static final Map<String, Map<String, StructureConfigEntry>> CONFIG_MAP = new HashMap<String, Map<String, StructureConfigEntry>>();
    private static File configDir;
    private static File configFile;

    public StructureConfig(String configId) {
        this.configId = configId;
    }

    public void addKey(String key, boolean defaultValue, float chance) {
        this.entries.put(key, new StructureConfigEntry(defaultValue, chance));
    }

    public static void addConfig(StructureConfig config) {
        CONFIG_MAP.put(config.configId, config.entries);
    }

    private static void rewrite() {
        try {
            if (configFile == null) {
                return;
            }
            FileWriter writer = new FileWriter(configFile);
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson(CONFIG_MAP));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void reload() {
        StructureConfig.load(configDir);
    }

    public static boolean isEnabled(String configKey, String key) {
        return StructureConfig.CONFIG_MAP.get((Object)configKey).get((Object)key).enabled;
    }

    public static float getChance(String configKey, String key) {
        return StructureConfig.CONFIG_MAP.get((Object)configKey).get((Object)key).chanceToSpawn;
    }

    public static void load(File configDir) {
        StructureConfig.configDir = configDir;
        configFile = new File(configDir, "jsg/jsgStructuresConfig_1.0.json");
        try {
            Type typeOfHashMap = new TypeToken<Map<String, Map<String, StructureConfigEntry>>>(){}.getType();
            Map tempMap = (Map)new GsonBuilder().create().fromJson((Reader)new FileReader(configFile), typeOfHashMap);
            if (tempMap.size() != CONFIG_MAP.size()) {
                StructureConfig.rewrite();
                return;
            }
            CONFIG_MAP.clear();
            for (String configKey : tempMap.keySet()) {
                HashMap<String, StructureConfigEntry> map = new HashMap<String, StructureConfigEntry>();
                for (String key : ((Map)tempMap.get(configKey)).keySet()) {
                    map.put(key, (StructureConfigEntry)((Map)tempMap.get(configKey)).get(key));
                }
                CONFIG_MAP.put(configKey, map);
            }
        }
        catch (FileNotFoundException exception) {
            StructureConfig.rewrite();
            StructureConfig.load(configDir);
        }
    }

    public static class StructureConfigEntry {
        public final boolean enabled;
        public final float chanceToSpawn;

        public StructureConfigEntry(boolean enabled, float chanceToSpawn) {
            this.enabled = enabled;
            this.chanceToSpawn = chanceToSpawn;
        }

        public String toString() {
            return "[enabled=" + this.enabled + ", chance=" + this.chanceToSpawn + "]";
        }
    }
}

