/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config.ingame;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tauri.dev.jsg.JSG;
import tauri.dev.jsg.config.ingame.JSGConfigEnumEntry;
import tauri.dev.jsg.config.ingame.JSGConfigOptionTypeEnum;
import tauri.dev.jsg.gui.element.EnumButton;
import tauri.dev.jsg.gui.element.ModeButton;
import tauri.dev.jsg.gui.element.NumberOnlyTextField;

public class JSGConfigOption {
    public int id;
    public List<String> comment = new ArrayList<String>();
    public List<JSGConfigEnumEntry> possibleValues = new ArrayList<JSGConfigEnumEntry>();
    public JSGConfigOptionTypeEnum type = JSGConfigOptionTypeEnum.TEXT;
    public String value = "";
    public String defaultValue = "";
    private String label = "";
    private int minInt = -1;
    private int maxInt = -1;
    protected static final int X = -25;

    public JSGConfigOption(int id) {
        this.id = id;
    }

    public JSGConfigOption(NBTTagCompound compound) {
        this.deserializeNBT(compound);
    }

    public JSGConfigOption(ByteBuf buf) {
        this.fromBytes(buf);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiTextField createField(int y) {
        int componentId = this.id + 100;
        NumberOnlyTextField field = this.type == JSGConfigOptionTypeEnum.NUMBER ? new NumberOnlyTextField(componentId, Minecraft.func_71410_x().field_71466_p, -25, y, 90, 15) : new GuiTextField(componentId, Minecraft.func_71410_x().field_71466_p, -25, y, 90, 15);
        field.func_146180_a(this.value);
        return field;
    }

    @SideOnly(value=Side.CLIENT)
    public ModeButton createButton(int y) {
        int componentId = this.id + 100;
        String textureBase = "textures/gui/config/";
        ModeButton button = null;
        if (this.type == JSGConfigOptionTypeEnum.BOOLEAN) {
            button = new ModeButton(componentId, -25, y, 16, new ResourceLocation("jsg", textureBase + "boolean_modes.png"), 32, 32, 2);
        }
        if (this.type == JSGConfigOptionTypeEnum.SWITCH) {
            button = new EnumButton(componentId, -25, y, this.possibleValues);
        }
        if (button != null) {
            button.setCurrentState(this.getIntValue());
        }
        return button;
    }

    public String getLabel() {
        return this.label;
    }

    public JSGConfigOption setLabel(String label) {
        this.label = label;
        return this;
    }

    protected String getDefaultValueToDisplay() {
        if (this.type == JSGConfigOptionTypeEnum.SWITCH) {
            try {
                return this.possibleValues.get((int)Integer.parseInt((String)this.defaultValue)).name;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.defaultValue;
    }

    public List<String> getCommentToRender() {
        ArrayList<String> c = new ArrayList<String>(this.getComment());
        c.add("---------------------------------");
        if (this.minInt != -1) {
            c.add("Min: " + this.minInt);
        }
        if (this.maxInt != -1) {
            c.add("Max: " + this.maxInt);
        }
        c.add("Default: " + this.getDefaultValueToDisplay());
        c.add("---------------------------------");
        return c;
    }

    public List<String> getComment() {
        return this.comment;
    }

    public JSGConfigOption setComment(String ... comment) {
        this.comment = Arrays.asList(comment);
        return this;
    }

    public JSGConfigOption setType(JSGConfigOptionTypeEnum type) {
        this.type = type;
        return this;
    }

    public JSGConfigOption setValue(String value) {
        if (this.type == JSGConfigOptionTypeEnum.NUMBER || this.type == JSGConfigOptionTypeEnum.SWITCH) {
            return this.setIntValue(value);
        }
        if (this.type == JSGConfigOptionTypeEnum.BOOLEAN) {
            return this.setBooleanValue(value);
        }
        return this.setStringValue(value);
    }

    public JSGConfigOption setPossibleValues(List<JSGConfigEnumEntry> values) {
        if (this.type != JSGConfigOptionTypeEnum.SWITCH) {
            JSG.error("Can not set values of config option!");
            JSG.error("Option is not SWITCH type!");
            return this;
        }
        return this.setEnumValues(values);
    }

    public JSGConfigOption setDefaultValue(String value) {
        this.defaultValue = value;
        return this;
    }

    public JSGConfigOption setMinInt(int value) {
        this.minInt = value;
        return this;
    }

    public JSGConfigOption setMaxInt(int value) {
        this.maxInt = value;
        return this;
    }

    public boolean getBooleanValue() {
        if (this.value == null) {
            return false;
        }
        return this.value.equals("true");
    }

    private JSGConfigOption setBooleanValue(String value) {
        this.value = value.equals("true") || value.equals("1") ? "true" : "false";
        return this;
    }

    public int getIntValue() {
        return this.getIntValue(false);
    }

    public int getIntValue(boolean getDefault) {
        String v = this.value;
        if (getDefault) {
            v = this.defaultValue;
        }
        if (v == null) {
            return 0;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (Exception e) {
            if (v.equals("true")) {
                return 1;
            }
            return 0;
        }
    }

    private JSGConfigOption setIntValue(String value) {
        try {
            int i = Integer.parseInt(value);
            if (!(this.maxInt != -1 && i > this.maxInt || this.minInt != -1 && i < this.minInt)) {
                this.value = i + "";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public String getStringValue() {
        return this.value;
    }

    private JSGConfigOption setStringValue(String value) {
        this.value = value;
        return this;
    }

    @Nonnull
    public JSGConfigEnumEntry getEnumValue() {
        if (this.possibleValues.size() <= this.getIntValue()) {
            return new JSGConfigEnumEntry("null", "-1");
        }
        JSGConfigEnumEntry t = this.possibleValues.get(this.getIntValue());
        if (t != null) {
            return t;
        }
        return new JSGConfigEnumEntry("null", "-1");
    }

    private JSGConfigOption setEnumValues(List<JSGConfigEnumEntry> entries) {
        this.possibleValues = entries;
        return this;
    }

    public NBTTagCompound serializeNBT() {
        int i;
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("id", this.id);
        compound.func_74778_a("label", this.label);
        compound.func_74768_a("commentSize", this.comment.size());
        for (i = 0; i < this.comment.size(); ++i) {
            compound.func_74778_a("comment" + i, this.comment.get(i));
        }
        compound.func_74768_a("type", this.type.id);
        compound.func_74778_a("value", this.value);
        compound.func_74768_a("minInt", this.minInt);
        compound.func_74768_a("maxInt", this.maxInt);
        compound.func_74778_a("defaultValue", this.defaultValue);
        compound.func_74768_a("possibleValuesLength", this.possibleValues.size());
        i = 0;
        for (JSGConfigEnumEntry e : this.possibleValues) {
            compound.func_74778_a("possibleValue" + i, e.value);
            compound.func_74778_a("possibleValueName" + i++, e.name);
        }
        return compound;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.id = compound.func_74762_e("id");
        this.label = compound.func_74779_i("label");
        int size = compound.func_74762_e("commentSize");
        this.comment.clear();
        for (int i = 0; i < size; ++i) {
            this.comment.add(compound.func_74779_i("comment" + i));
        }
        this.type = JSGConfigOptionTypeEnum.byId(compound.func_74762_e("type"));
        this.value = compound.func_74779_i("value");
        this.minInt = compound.func_74762_e("minInt");
        this.maxInt = compound.func_74762_e("maxInt");
        this.defaultValue = compound.func_74779_i("defaultValue");
        this.possibleValues = new ArrayList<JSGConfigEnumEntry>();
        int s = compound.func_74762_e("possibleValuesLength");
        for (int i = 0; i < s; ++i) {
            this.possibleValues.add(new JSGConfigEnumEntry(compound.func_74779_i("possibleValueName" + i), compound.func_74779_i("possibleValue" + i)));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.label.length());
        buf.writeCharSequence((CharSequence)this.label, StandardCharsets.UTF_8);
        buf.writeInt(this.comment.size());
        for (String com : this.comment) {
            buf.writeInt(com.length());
            buf.writeCharSequence((CharSequence)com, StandardCharsets.UTF_8);
        }
        buf.writeInt(this.type.id);
        buf.writeInt(this.value.length());
        buf.writeCharSequence((CharSequence)this.value, StandardCharsets.UTF_8);
        buf.writeInt(this.minInt);
        buf.writeInt(this.maxInt);
        buf.writeInt(this.defaultValue.length());
        buf.writeCharSequence((CharSequence)this.defaultValue, StandardCharsets.UTF_8);
        buf.writeInt(this.possibleValues.size());
        for (JSGConfigEnumEntry e : this.possibleValues) {
            buf.writeInt(e.value.length());
            buf.writeCharSequence((CharSequence)e.value, StandardCharsets.UTF_8);
            buf.writeInt(e.name.length());
            buf.writeCharSequence((CharSequence)e.name, StandardCharsets.UTF_8);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        int labelSize = buf.readInt();
        this.label = buf.readCharSequence(labelSize, StandardCharsets.UTF_8).toString();
        int commentsSize = buf.readInt();
        this.comment.clear();
        for (int i = 0; i < commentsSize; ++i) {
            int x = buf.readInt();
            this.comment.add(buf.readCharSequence(x, StandardCharsets.UTF_8).toString());
        }
        this.type = JSGConfigOptionTypeEnum.byId(buf.readInt());
        int valueSize = buf.readInt();
        this.value = buf.readCharSequence(valueSize, StandardCharsets.UTF_8).toString();
        this.minInt = buf.readInt();
        this.maxInt = buf.readInt();
        int defaultValueSize = buf.readInt();
        this.defaultValue = buf.readCharSequence(defaultValueSize, StandardCharsets.UTF_8).toString();
        this.possibleValues = new ArrayList<JSGConfigEnumEntry>();
        int s = buf.readInt();
        for (int i = 0; i < s; ++i) {
            int valueSize2 = buf.readInt();
            String value = buf.readCharSequence(valueSize2, StandardCharsets.UTF_8).toString();
            int nameSize = buf.readInt();
            String name = buf.readCharSequence(nameSize, StandardCharsets.UTF_8).toString();
            this.possibleValues.add(new JSGConfigEnumEntry(name, value));
        }
    }
}

