/*
 * Decompiled with CFR 0.152.
 */
package tauri.dev.jsg.config.craftings;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public class CraftingConfig {
    private final Map<String, Boolean> entries = new HashMap<String, Boolean>();
    private final String configId;
    private static final Map<String, Map<String, Boolean>> CONFIG_MAP = new HashMap<String, Map<String, Boolean>>();
    private static File configDir;
    private static File configFile;

    public CraftingConfig(String configId) {
        this.configId = configId;
    }

    public void addKey(@Nullable ResourceLocation key) {
        if (key == null) {
            return;
        }
        this.addKey(key.func_110624_b() + ":" + key.func_110623_a());
    }

    public void addKey(String key) {
        this.entries.put(key, true);
    }

    public static void addConfig(CraftingConfig config) {
        CONFIG_MAP.put(config.configId, config.entries);
    }

    private static void rewrite() {
        try {
            if (configFile == null) {
                return;
            }
            FileWriter writer = new FileWriter(configFile);
            writer.write(new GsonBuilder().setPrettyPrinting().create().toJson(CONFIG_MAP));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void reload() {
        CraftingConfig.load(configDir);
    }

    public static boolean isDisabled(String configKey, @Nullable ResourceLocation key) {
        if (key == null) {
            return false;
        }
        return CraftingConfig.isDisabled(configKey, key.func_110624_b() + ":" + key.func_110623_a());
    }

    public static boolean isDisabled(String configKey, String key) {
        return CONFIG_MAP.get(configKey).get(key) == false;
    }

    public static void load(File configDir) {
        CraftingConfig.configDir = configDir;
        configFile = new File(configDir, "jsg/jsgEnabledCraftings_1.1.json");
        try {
            Type typeOfHashMap = new TypeToken<Map<String, Map<String, Boolean>>>(){}.getType();
            Map tempMap = (Map)new GsonBuilder().create().fromJson((Reader)new FileReader(configFile), typeOfHashMap);
            if (tempMap.size() != CONFIG_MAP.size()) {
                CraftingConfig.rewrite();
                return;
            }
            CONFIG_MAP.clear();
            for (String configKey : tempMap.keySet()) {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                for (String key : ((Map)tempMap.get(configKey)).keySet()) {
                    map.put(key, (Boolean)((Map)tempMap.get(configKey)).get(key));
                }
                CONFIG_MAP.put(configKey, map);
            }
        }
        catch (FileNotFoundException exception) {
            CraftingConfig.rewrite();
            CraftingConfig.load(configDir);
        }
    }
}

