/*
 * Decompiled with CFR 0.152.
 */
package codechicken.wirelessredstone.client.gui;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import codechicken.lib.config.ConfigTag;
import codechicken.lib.texture.TextureUtils;
import codechicken.wirelessredstone.manager.RedstoneEther;
import codechicken.wirelessredstone.manager.RedstoneEtherAddons;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;

public class GuiWirelessSniffer
extends GuiScreen {
    public String title = "Wireless Sniffer";
    private int page = 0;
    private byte[] ethercopy = new byte[625];
    protected byte[] brightness = new byte[5000];
    public static int xSize = 256;
    public static int ySize = 200;
    public static ColourARGB colourOn;
    public static ColourARGB colourOff;
    public static ColourARGB colourPOn;
    public static ColourARGB colourPOff;
    public static ColourARGB colourJammed;
    public static ColourARGB borderOn;
    public static ColourARGB borderOff;
    public static ColourARGB borderPOn;
    public static ColourARGB borderPOff;
    public static ColourARGB borderJammed;
    public static final int blocksize = 5;

    public void func_73866_w_() {
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 40, this.field_146295_m / 2 + 75, 50, 20, "Next"));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 - 90, this.field_146295_m / 2 + 75, 50, 20, "Prev"));
        super.func_73866_w_();
    }

    protected void func_146284_a(GuiButton guibutton) {
        switch (guibutton.field_146127_k) {
            case 0: {
                ++this.page;
                break;
            }
            case 1: {
                --this.page;
            }
        }
        if (this.page < 0) {
            this.page = 4;
        } else if (this.page > 4) {
            this.page = 0;
        }
    }

    public int getFreqMouseOver(int mousex, int mousey) {
        int xfreq = (mousex - ((this.field_146294_l - xSize) / 2 + 8)) / 6;
        int yfreq = (mousey - ((this.field_146295_m - ySize) / 2 + 24)) / 6;
        if (xfreq < 0 || xfreq >= 40 || yfreq < 0 || yfreq >= 25) {
            return 0;
        }
        return this.page * 1000 + 1 + yfreq * 40 + xfreq;
    }

    public void func_73863_a(int mousex, int mousey, float partialframe) {
        this.func_146276_q_();
        int backtexx = (this.field_146294_l - xSize) / 2;
        int backtexy = (this.field_146295_m - ySize) / 2;
        int startfreq = this.page * 1000 + 1;
        int endfreq = (this.page + 1) * 1000;
        if (endfreq > 5000) {
            endfreq = 5000;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureUtils.changeTexture((String)"wrcbe:textures/gui/sniffer.png");
        this.func_73729_b(backtexx, backtexy, 0, 0, xSize, ySize);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)backtexx, (float)backtexy, (float)0.0f);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.field_146289_q.func_78276_b(this.title, xSize / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 10, 0x404040);
        this.drawFrequencies(8, 24, startfreq);
        String rangestring = "" + startfreq + " - " + endfreq;
        this.field_146289_q.func_78276_b(rangestring, xSize / 2 - this.field_146289_q.func_78256_a(rangestring) / 2, 181, 0x404040);
        GlStateManager.func_179121_F();
        int freq = this.getFreqMouseOver(mousex, mousey);
        if (freq != 0) {
            String freqname = this.getFreqTip(freq);
            int width = this.field_146289_q.func_78256_a(freqname);
            this.func_73733_a(mousex, mousey - 12, mousex + width + 3, mousey, -1073741824, -1073741824);
            this.field_146289_q.func_175063_a(freqname, (float)(mousex + 2), (float)(mousey - 10), -1);
        }
        super.func_73863_a(mousex, mousey, partialframe);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public String getFreqTip(int freq) {
        String name = RedstoneEther.get(true).getFreqName(freq);
        return Integer.toString(freq) + (name == null || name.equals("") ? "" : " " + name);
    }

    public Colour getColour(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)this.field_146297_k.field_71439_g) || !RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, freq)) {
            return colourJammed;
        }
        return colourOff.copy().interpolate((Colour)colourOn, (double)((float)this.brightness[freq - 1] / 64.0f));
    }

    public Colour getBorder(int freq) {
        if (RedstoneEther.get(true).isPlayerJammed((EntityPlayer)this.field_146297_k.field_71439_g) || !RedstoneEther.get(true).canBroadcastOnFrequency((EntityPlayer)this.field_146297_k.field_71439_g, freq)) {
            return borderJammed;
        }
        if (RedstoneEther.get(true).getFreqColourId(freq) != -1) {
            return new ColourARGB(RedstoneEther.get(true).getFreqColour(freq));
        }
        return borderOff.copy().interpolate((Colour)borderOn, (double)((float)this.brightness[freq - 1] / 64.0f));
    }

    public boolean func_73868_f() {
        return false;
    }

    private void drawFrequencies(int xstart, int ystart, int freqstart) {
        int freq = freqstart;
        for (int yfreq = 0; yfreq < 25; ++yfreq) {
            for (int xfreq = 0; xfreq < 40; ++xfreq) {
                if (freq > 5000) {
                    return;
                }
                int x = xstart + 6 * xfreq;
                int y = ystart + 6 * yfreq;
                GuiWirelessSniffer.func_73734_a((int)x, (int)y, (int)(x + 5), (int)(y + 5), (int)this.getBorder(freq).argb());
                GuiWirelessSniffer.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 5 - 1), (int)(y + 5 - 1), (int)this.getColour(freq).argb());
                ++freq;
            }
        }
    }

    public void func_146281_b() {
        RedstoneEtherAddons.client().remSniffer((EntityPlayer)this.field_146297_k.field_71439_g);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (int freq = 0; freq < 5000; ++freq) {
            if ((this.ethercopy[freq >> 3] & 1 << (freq & 7)) != 0) {
                if (this.brightness[freq] < 1) {
                    this.brightness[freq] = 1;
                }
                this.brightness[freq] = 64;
                if ((this.brightness[freq] & 0xFF) <= 64) continue;
                this.brightness[freq] = 64;
                continue;
            }
            int n = freq;
            this.brightness[n] = (byte)((double)this.brightness[n] * 0.9);
        }
    }

    public void setEtherCopy(byte[] copy) {
        this.ethercopy = copy;
    }

    public void setEtherFreq(int freq, boolean state) {
        --freq;
        if (state) {
            int n = freq >> 3;
            this.ethercopy[n] = (byte)(this.ethercopy[n] | 1 << (freq & 7));
            this.brightness[freq] = 64;
        } else {
            int n = freq >> 3;
            this.ethercopy[n] = (byte)(this.ethercopy[n] & (1 << (freq & 7) ^ 0xFF));
        }
    }

    public static void loadColours(ConfigTag addonconfig) {
        ConfigTag snifferconifg = addonconfig.getTag("sniffer.gui").useBraces();
        ConfigTag colourconfig = snifferconifg.getTag("colour").setPosition(0).setComment("Colours are in 0xAARRGGBB format:Alpha should be FF");
        ConfigTag borderconfig = snifferconifg.getTag("border").setPosition(1).setNewLine(true);
        colourOn = new ColourARGB(colourconfig.getTag("on").setPosition(0).setComment("").getHexValue(-65536));
        colourOff = new ColourARGB(colourconfig.getTag("off").setPosition(1).getHexValue(-9437184));
        colourJammed = new ColourARGB(colourconfig.getTag("jammed").setPosition(2).getHexValue(-9408400));
        colourPOn = new ColourARGB(colourconfig.getTag("private.on").setPosition(0).getHexValue(-12521472));
        colourPOff = new ColourARGB(colourconfig.getTag("private.off").setPosition(1).getHexValue(-12541952));
        borderOn = new ColourARGB(borderconfig.getTag("on").setPosition(0).getHexValue(-1179648));
        borderOff = new ColourARGB(borderconfig.getTag("off").setPosition(1).getHexValue(-11534336));
        borderJammed = new ColourARGB(borderconfig.getTag("jammed").setPosition(2).getHexValue(-11513776));
        borderPOn = new ColourARGB(borderconfig.getTag("private.on").setPosition(0).getHexValue(-14622720));
        borderPOff = new ColourARGB(borderconfig.getTag("private.off").setPosition(1).getHexValue(-14643200));
    }
}

