/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocsensors.sensor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.dave.ocsensors.base.TileEntitySidedEnvironmentBase;
import org.dave.ocsensors.integration.AbstractIntegration;
import org.dave.ocsensors.integration.IntegrationRegistry;
import org.dave.ocsensors.misc.ConfigurationHandler;

public class TileEntitySensor
extends TileEntitySidedEnvironmentBase {
    public TileEntitySensor() {
        super("sensor", Arrays.asList(EnumFacing.UP, EnumFacing.EAST, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.SOUTH));
    }

    @Callback(getter=true, doc="Maximum range the sensor can scan blocks")
    public Object[] range(Context context, Arguments args) {
        return new Object[]{Float.valueOf(ConfigurationHandler.SensorSettings.maxRange)};
    }

    @Callback(getter=true, doc="Maximum range the sensor can search for specific blocks")
    public Object[] searchRange(Context context, Arguments args) {
        return new Object[]{Float.valueOf(ConfigurationHandler.SensorSettings.maxSearchRange)};
    }

    @Callback(limit=1, doc="function(x1:number, y1:number, z1:number, x2:number, y2:number, z3:number):table -- Scans a region relative to the sensor for entities")
    public Object[] searchEntities(Context context, Arguments args) {
        int xDelta1 = args.checkInteger(0);
        int yDelta1 = args.checkInteger(1);
        int zDelta1 = args.checkInteger(2);
        int xDelta2 = args.checkInteger(3);
        int yDelta2 = args.checkInteger(4);
        int zDelta2 = args.checkInteger(5);
        BlockPos startPoint = this.func_174877_v().func_177982_a(xDelta1, yDelta1, zDelta1);
        BlockPos endPoint = this.func_174877_v().func_177982_a(xDelta2, yDelta2, zDelta2);
        AxisAlignedBB boundingBox = new AxisAlignedBB(startPoint, endPoint).func_186662_g(0.5).func_72317_d(0.5, 0.5, 0.5);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Entity entity : this.func_145831_w().func_72872_a(Entity.class, boundingBox)) {
            if (!ConfigurationHandler.SensorSettings.disableScanPause) {
                context.pause((double)ConfigurationHandler.SensorSettings.pauseForEntity);
            }
            if (ConfigurationHandler.SensorSettings.hideSneakingEntities && entity instanceof EntityLivingBase && entity.func_70093_af()) continue;
            Map<String, Object> entityData = IntegrationRegistry.getDataForEntity(entity);
            if (!entityData.containsKey("type")) {
                if (entity instanceof EntityItem) {
                    entityData.put("type", "item");
                }
                if (entity instanceof EntityLivingBase) {
                    entityData.put("type", "neutral");
                }
                if (entity instanceof EntityMob) {
                    entityData.put("type", "mob");
                }
                if (entity instanceof EntityPlayer) {
                    entityData.put("type", "player");
                }
            }
            if (!entityData.containsKey("type")) continue;
            HashMap<String, Double> posMap = new HashMap<String, Double>();
            posMap.put("x", entity.func_174791_d().field_72450_a - (double)this.func_174877_v().func_177958_n());
            posMap.put("y", entity.func_174791_d().field_72448_b - (double)this.func_174877_v().func_177956_o());
            posMap.put("z", entity.func_174791_d().field_72449_c - (double)this.func_174877_v().func_177952_p());
            entityData.put("pos", posMap);
            result.add(entityData);
        }
        return new Object[]{result};
    }

    @Callback(limit=1, doc="function(x:number, y:number, z:number, [side:number]):table -- Scans a block relative to the sensor")
    public Object[] scan(Context context, Arguments args) {
        int zDelta;
        int yDelta;
        int xDelta = args.checkInteger(0);
        double length = Math.sqrt(xDelta * xDelta + (yDelta = args.checkInteger(1)) * yDelta + (zDelta = args.checkInteger(2)) * zDelta);
        if (length > (double)ConfigurationHandler.SensorSettings.maxRange) {
            return new Object[]{null, "out of range"};
        }
        int sideInt = args.optInteger(3, -1);
        EnumFacing side = sideInt == -1 ? null : EnumFacing.func_82600_a((int)sideInt);
        BlockPos pos = this.func_174877_v().func_177982_a(xDelta, yDelta, zDelta);
        IBlockState state = this.func_145831_w().func_180495_p(pos);
        Block block = state.func_177230_c();
        HashMap<String, Object> blockInfo = new HashMap<String, Object>();
        blockInfo.put("name", block.getRegistryName());
        blockInfo.put("meta", block.func_176201_c(state));
        int redstonePower = this.func_145831_w().func_175651_c(pos, side != null ? side : EnumFacing.UP);
        if (redstonePower > 0) {
            blockInfo.put("redstonePower", redstonePower);
        }
        if (!this.func_145831_w().func_175623_d(pos)) {
            ItemStack stack;
            if (!ConfigurationHandler.SensorSettings.disableScanPause) {
                context.pause((double)ConfigurationHandler.SensorSettings.pauseForBlock);
            }
            if (!(stack = block.getPickBlock(state, null, this.func_145831_w(), pos, null)).func_190926_b()) {
                blockInfo.put("label", stack.func_82833_r());
            } else {
                blockInfo.put("label", block.getRegistryName());
            }
        } else if (!ConfigurationHandler.SensorSettings.disableScanPause) {
            context.pause((double)ConfigurationHandler.SensorSettings.pauseForAirBlock);
        }
        TileEntity entity = this.func_145831_w().func_175625_s(pos);
        Map<String, Object> blockData = null;
        if (entity != null) {
            if (!ConfigurationHandler.SensorSettings.disableScanPause) {
                context.pause((double)ConfigurationHandler.SensorSettings.pauseForTileEntity);
            }
            blockData = IntegrationRegistry.getDataForTileEntity(entity, side);
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        result.put("block", blockInfo);
        result.put("data", blockData);
        return new Object[]{result};
    }

    @Callback(limit=1, doc="function([name:string=\"\"], [meta:number=-1], [section:string=\"\"], [range:number=<max>]):table -- Search for blocks matching the given criteria in the given range")
    public Object[] search(Context context, Arguments args) {
        if (ConfigurationHandler.SensorSettings.disableSearch) {
            return new Object[]{null, "command is disabled in config"};
        }
        String name = args.optString(0, "");
        int meta = args.optInteger(1, -1);
        String section = args.optString(2, "");
        double rangeD = (int)Math.floor(Math.min((double)ConfigurationHandler.SensorSettings.maxSearchRange, args.optDouble(3, (double)ConfigurationHandler.SensorSettings.maxSearchRange)));
        if (name.length() == 0 && meta == -1 && section.length() == 0) {
            return new Object[]{null, "no search criteria specified"};
        }
        AbstractIntegration wantedIntegration = null;
        if (section.length() > 0 && (wantedIntegration = IntegrationRegistry.getIntegrationByName(section)) == null) {
            return new Object[]{null, "invalid search criteria, section does not exist"};
        }
        int range = (int)Math.floor(rangeD);
        float totalSleep = 0.0f;
        ArrayList result = new ArrayList();
        for (int x = this.func_174877_v().func_177958_n() - range; x <= this.func_174877_v().func_177958_n() + range; ++x) {
            for (int y = this.func_174877_v().func_177956_o() - range; y <= this.func_174877_v().func_177956_o() + range; ++y) {
                for (int z = this.func_174877_v().func_177952_p() - range; z <= this.func_174877_v().func_177952_p() + range; ++z) {
                    TileEntity entity;
                    double length;
                    int xDelta = x - this.func_174877_v().func_177958_n();
                    int yDelta = y - this.func_174877_v().func_177956_o();
                    int zDelta = z - this.func_174877_v().func_177952_p();
                    if (xDelta == 0 && yDelta == 0 && zDelta == 0 || (length = Math.sqrt(xDelta * xDelta + yDelta * yDelta + zDelta * zDelta)) > rangeD) continue;
                    totalSleep += ConfigurationHandler.SensorSettings.pauseForSearchPerBlock;
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState state = this.func_145831_w().func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (name.length() > 0 && !name.equalsIgnoreCase(block.getRegistryName().toString()) || meta > -1 && meta != block.func_176201_c(state) || section.length() > 0 && ((entity = this.func_145831_w().func_175625_s(pos)) == null || !wantedIntegration.worksWith(entity, null))) continue;
                    HashMap<String, Integer> posMap = new HashMap<String, Integer>();
                    posMap.put("x", xDelta);
                    posMap.put("y", yDelta);
                    posMap.put("z", zDelta);
                    result.add(posMap);
                }
            }
        }
        if (!ConfigurationHandler.SensorSettings.disableSearchPause) {
            context.pause((double)totalSleep);
        }
        return new Object[]{result};
    }
}

