/*
 * Decompiled with CFR 0.152.
 */
package fossilsarcheology.server.block;

import fossilsarcheology.Revival;
import fossilsarcheology.server.api.BlockEntity;
import fossilsarcheology.server.api.DefaultRenderedItem;
import fossilsarcheology.server.block.FABlockRegistry;
import fossilsarcheology.server.block.TallFlowerBlock;
import fossilsarcheology.server.block.entity.TileEntityCultivate;
import fossilsarcheology.server.entity.monster.EntityFailuresaurus;
import fossilsarcheology.server.tab.FATabRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CultivateBlock
extends BlockContainer
implements DefaultRenderedItem,
BlockEntity {
    private static boolean keepInventory = false;

    public CultivateBlock(boolean isActive) {
        super(Material.field_151573_f);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
        if (isActive) {
            this.func_149715_a(0.9375f);
            this.func_149663_c("cultivate_active");
        } else {
            this.func_149663_c("cultivate");
            this.func_149647_a(FATabRegistry.BLOCKS);
        }
    }

    public static void setState(boolean isActive, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        keepInventory = true;
        if (isActive) {
            world.func_175656_a(pos, FABlockRegistry.CULTIVATE_ACTIVEE.func_176223_P());
        } else {
            world.func_175656_a(pos, FABlockRegistry.CULTIVATE_IDLE.func_176223_P());
        }
        keepInventory = false;
        if (tile != null) {
            tile.func_145829_t();
            world.func_175690_a(pos, tile);
        }
    }

    public void onBlockRemovalLost(World world, BlockPos pos, boolean isActive) {
        TileEntityCultivate entity;
        keepInventory = false;
        List nearby = world.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)pos.func_177958_n() - 50.0, (double)pos.func_177956_o() - 50.0, (double)pos.func_177952_p() - 50.0, (double)pos.func_177958_n() + 50.0, (double)pos.func_177956_o() + 50.0, (double)pos.func_177952_p() + 50.0));
        for (EntityPlayer player : nearby) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("cultivate.outBreak", new Object[0]), false);
        }
        this.returnIron(world, pos);
        this.dropInventory(world, pos);
        if (!world.field_72995_K && isActive && (entity = (TileEntityCultivate)world.func_175625_s(pos)) != null) {
            world.func_175655_b(pos, false);
            if (entity.isPlant) {
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                world.func_175656_a(pos.func_177984_a(), FABlockRegistry.MUTANT_FLOWER.func_176223_P().func_177226_a(TallFlowerBlock.HALF, (Comparable)((Object)TallFlowerBlock.EnumBlockHalf.LOWER)));
                if (world.func_180495_p(pos).func_185904_a().func_76222_j()) {
                    world.func_175656_a(pos.func_177981_b(2), FABlockRegistry.MUTANT_FLOWER.func_176223_P().func_177226_a(TallFlowerBlock.HALF, (Comparable)((Object)TallFlowerBlock.EnumBlockHalf.UPPER)));
                }
            } else {
                Object creature;
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187561_bM, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                if (!world.field_73011_w.func_177500_n()) {
                    world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                    world.func_184138_a(pos, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), 3);
                } else {
                    world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
                }
                int rand = world.field_73012_v.nextInt(100);
                if (rand <= 5) {
                    creature = new EntityCreeper(world);
                } else if (rand < 10) {
                    creature = new EntityPigZombie(world);
                } else if (rand > 10 && rand < 15) {
                    creature = new EntityZombieHorse(world);
                } else if (rand > 15 && rand < 20) {
                    creature = new EntityMooshroom(world);
                } else {
                    creature = new EntityFailuresaurus(world);
                    ((EntityFailuresaurus)((Object)creature)).setSkin(new Random().nextInt(3));
                }
                creature.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, world.field_73012_v.nextFloat() * 360.0f, 0.0f);
                world.func_72838_d((Entity)creature);
            }
            world.func_175713_t(pos);
        }
    }

    private void returnIron(World world, BlockPos pos) {
        Random rand = new Random();
        ItemStack stack = new ItemStack(Items.field_151042_j, 1 + world.field_73012_v.nextInt(2));
        float offsetX = rand.nextFloat() * 0.8f + 0.1f;
        float offsetY = rand.nextFloat() * 0.8f + 0.1f;
        float offsetZ = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + offsetX), (double)((float)pos.func_177956_o() + offsetY), (double)((float)pos.func_177952_p() + offsetZ), stack);
        float motionMutlipler = 0.05f;
        item.field_70159_w = (float)rand.nextGaussian() * motionMutlipler;
        item.field_70181_x = (float)rand.nextGaussian() * motionMutlipler + 0.2f;
        item.field_70179_y = (float)rand.nextGaussian() * motionMutlipler;
        world.func_72838_d((Entity)item);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public Item func_180660_a(IBlockState state, Random random, int fortune) {
        return Item.func_150898_a((Block)FABlockRegistry.CULTIVATE_IDLE);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)Revival.INSTANCE, 1, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile;
        if (stack.func_82837_s() && (tile = world.func_175625_s(pos)) instanceof TileEntityCultivate) {
            ((TileEntityCultivate)tile).setCustomName(stack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropInventory(world, pos);
        super.func_180663_b(world, pos, state);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (!keepInventory) {
            TileEntity entity = world.func_175625_s(pos);
            if (entity == null) {
                return;
            }
            IItemHandler inventory = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (inventory == null) {
                return;
            }
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityCultivate();
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        int i = 0;
        float f = 0.0f;
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityCultivate) {
            TileEntityCultivate te = (TileEntityCultivate)world.func_175625_s(pos);
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = te.globalInventory.getStackInSlot(j);
                if (itemstack.func_190926_b()) continue;
                f += (float)itemstack.func_190916_E() / (float)Math.min(64, itemstack.func_77976_d());
                ++i;
            }
            return MathHelper.func_76141_d((float)((f /= 3.0f) * 14.0f)) + (i > 0 ? 1 : 0);
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)FABlockRegistry.CULTIVATE_IDLE);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public Class<? extends TileEntity> getEntity() {
        return TileEntityCultivate.class;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }
}

