/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.network.handlers;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.network.IPacketRegistry;
import betterquesting.api.network.IPacketSender;
import betterquesting.api.network.QuestingPacket;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.IQuestDatabase;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api2.cache.CapabilityProviderQuestCache;
import betterquesting.api2.cache.QuestCache;
import bq_standard.tasks.TaskCheckbox;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetTaskCheckbox {
    private static final ResourceLocation ID_NAME = new ResourceLocation("bq_standard:task_checkbox");

    public static void registerHandler() {
        ((IPacketRegistry)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_REG)).registerServerHandler(ID_NAME, NetTaskCheckbox::onServer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void requestClick(int questID, int taskID) {
        NBTTagCompound payload = new NBTTagCompound();
        payload.func_74768_a("questID", questID);
        payload.func_74768_a("taskID", taskID);
        ((IPacketSender)QuestingAPI.getAPI((ApiKey)ApiReference.PACKET_SENDER)).sendToServer(new QuestingPacket(ID_NAME, payload));
    }

    private static void onServer(Tuple<NBTTagCompound, EntityPlayerMP> message) {
        int tId;
        NBTTagCompound data = (NBTTagCompound)message.func_76341_a();
        EntityPlayerMP sender = (EntityPlayerMP)message.func_76340_b();
        int qId = !data.func_150297_b("questID", 99) ? -1 : data.func_74762_e("questID");
        int n = tId = !data.func_150297_b("taskID", 99) ? -1 : data.func_74762_e("taskID");
        if (qId >= 0 && tId >= 0) {
            ITask task;
            QuestCache qc = (QuestCache)sender.getCapability(CapabilityProviderQuestCache.CAP_QUEST_CACHE, null);
            IQuest quest = (IQuest)((IQuestDatabase)QuestingAPI.getAPI((ApiKey)ApiReference.QUEST_DB)).getValue(qId);
            ITask iTask = task = quest == null ? null : (ITask)quest.getTasks().getValue(tId);
            if (task instanceof TaskCheckbox) {
                task.setComplete(QuestingAPI.getQuestingUUID((EntityPlayer)sender));
                if (qc != null) {
                    qc.markQuestDirty(qId);
                }
            }
        }
    }
}

