/*
 * Decompiled with CFR 0.152.
 */
package bq_standard.items;

import betterquesting.api.api.ApiKey;
import betterquesting.api.api.ApiReference;
import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.storage.IQuestSettings;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.utils.QuestTranslation;
import bq_standard.core.BQ_Standard;
import bq_standard.network.handlers.NetLootClaim;
import bq_standard.rewards.loot.LootGroup;
import bq_standard.rewards.loot.LootRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLootChest
extends Item {
    private List<ItemStack> subItems = null;

    public ItemLootChest() {
        this.func_77625_d(1);
        this.func_77655_b("bq_standard.loot_chest");
        this.func_77637_a((CreativeTabs)QuestingAPI.getAPI((ApiKey)ApiReference.CREATIVE_TAB));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (stack.func_77952_i() == 104) {
            if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            NBTTagCompound tag = stack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            ArrayList<BigItemStack> lootItems = new ArrayList<BigItemStack>();
            String lootName = tag.func_74779_i("fixedLootName");
            NBTTagList lootList = tag.func_150295_c("fixedLootList", 10);
            for (int i = 0; i < lootList.func_74745_c(); ++i) {
                lootItems.add(new BigItemStack(lootList.func_150305_b(i)));
            }
            boolean invoChanged = false;
            for (BigItemStack s1 : lootItems) {
                for (ItemStack s2 : s1.getCombinedStacks()) {
                    if (!player.field_71071_by.func_70441_a(s2)) {
                        player.func_146097_a(s2, true, false);
                        continue;
                    }
                    if (invoChanged) continue;
                    invoChanged = true;
                }
            }
            if (invoChanged) {
                player.field_71071_by.func_70296_d();
                player.field_71069_bz.func_75142_b();
            }
            NetLootClaim.sendReward((EntityPlayerMP)player, lootName, lootItems.toArray(new BigItemStack[0]));
        } else if (stack.func_77952_i() == 103) {
            if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            LootContext lootcontext = new LootContext.Builder(((EntityPlayerMP)player).func_71121_q()).func_186472_a((Entity)player).func_186470_a(player).func_186469_a(player.func_184817_da()).func_186471_a();
            String loottable = stack.func_77978_p() != null && stack.func_77978_p().func_150297_b("loottable", 8) ? stack.func_77978_p().func_74779_i("loottable") : "minecraft:chests/simple_dungeon";
            ArrayList<BigItemStack> loot = new ArrayList<BigItemStack>();
            for (Object itemstack : player.field_70170_p.func_184146_ak().func_186521_a(new ResourceLocation(loottable)).func_186462_a(player.func_70681_au(), lootcontext)) {
                loot.add(new BigItemStack((ItemStack)itemstack));
            }
            boolean invoChanged = false;
            for (BigItemStack s1 : loot) {
                for (ItemStack s2 : s1.getCombinedStacks()) {
                    if (!player.field_71071_by.func_70441_a(s2)) {
                        player.func_146097_a(s2, true, false);
                        continue;
                    }
                    if (invoChanged) continue;
                    invoChanged = true;
                }
            }
            if (invoChanged) {
                player.field_71071_by.func_70296_d();
                player.field_71069_bz.func_75142_b();
            }
            NetLootClaim.sendReward((EntityPlayerMP)player, "Loot", loot.toArray(new BigItemStack[0]));
        } else {
            if (stack.func_77952_i() >= 102) {
                if (((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).canUserEdit(player)) {
                    player.openGui((Object)BQ_Standard.instance, 0, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                }
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (!world.field_72995_K) {
                float rarity = stack.func_77952_i() == 101 ? field_77697_d.nextFloat() : (float)MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)100) / 100.0f;
                LootGroup group = LootRegistry.INSTANCE.getWeightedGroup(rarity, field_77697_d);
                ArrayList<BigItemStack> loot = new ArrayList<BigItemStack>();
                String title = "No Loot Setup";
                if (group != null) {
                    title = group.name;
                    List<BigItemStack> tmp = group.getRandomReward(field_77697_d);
                    if (tmp != null) {
                        loot.addAll(tmp);
                    }
                }
                boolean invoChanged = false;
                for (BigItemStack s1 : loot) {
                    for (ItemStack s2 : s1.getCombinedStacks()) {
                        if (!player.field_71071_by.func_70441_a(s2)) {
                            player.func_146097_a(s2, true, false);
                            continue;
                        }
                        if (invoChanged) continue;
                        invoChanged = true;
                    }
                }
                if (invoChanged) {
                    player.field_71071_by.func_70296_d();
                    player.field_71069_bz.func_75142_b();
                }
                if (player instanceof EntityPlayerMP) {
                    NetLootClaim.sendReward((EntityPlayerMP)player, title, loot.toArray(new BigItemStack[0]));
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nonnull CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (tab != CreativeTabs.field_78027_g && tab != this.func_77640_w()) {
            return;
        }
        if (this.subItems != null) {
            list.addAll(this.subItems);
            return;
        }
        this.subItems = new ArrayList<ItemStack>();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("hideLootInfo", true);
        for (int i = 0; i < 5; ++i) {
            ItemStack tmp = new ItemStack((Item)this, 1, 25 * i);
            tmp.func_77982_d(tag.func_74737_b());
            this.subItems.add(tmp);
        }
        ItemStack tmp = new ItemStack((Item)this, 1, 101);
        tmp.func_77982_d(tag.func_74737_b());
        this.subItems.add(tmp);
        this.subItems.add(new ItemStack((Item)this, 1, 102));
        tag = new NBTTagCompound();
        tag.func_74757_a("hideLootInfo", true);
        tag.func_74778_a("loottable", "minecraft:chests/simple_dungeon");
        ItemStack lootStack = new ItemStack((Item)this, 1, 103);
        lootStack.func_77982_d(tag);
        this.subItems.add(lootStack);
        tag = new NBTTagCompound();
        tag.func_74757_a("hideLootInfo", true);
        NBTTagList tagList = new NBTTagList();
        tagList.func_74742_a((NBTBase)new BigItemStack(Blocks.field_150348_b).writeToNBT(new NBTTagCompound()));
        ItemStack fixedLootStack = new ItemStack((Item)this, 1, 104);
        tag.func_74782_a("fixedLootList", (NBTBase)tagList);
        tag.func_74778_a("fixedLootName", "Item Set");
        fixedLootStack.func_77982_d(tag);
        this.subItems.add(fixedLootStack);
        list.addAll(this.subItems);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77952_i() == 102;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        boolean hideTooltip;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound tag = stack.func_77978_p();
        boolean bl = hideTooltip = tag == null || !tag.func_74767_n("hideLootInfo");
        if (hideTooltip && !((Boolean)((IQuestSettings)QuestingAPI.getAPI((ApiKey)ApiReference.SETTINGS)).getProperty(NativeProps.EDIT_MODE)).booleanValue()) {
            return;
        }
        if (stack.func_77952_i() == 104) {
            if (tag == null) {
                return;
            }
            tooltip.add(QuestTranslation.translate((String)"bq_standard.tooltip.fixed_loot", (Object[])new Object[]{tag.func_74779_i("fixedLootName")}));
            tooltip.add(QuestTranslation.translate((String)"bq_standard.tooltip.fixed_loot_size", (Object[])new Object[]{tag.func_150295_c("fixedLootList", 10).func_74745_c()}));
        } else if (stack.func_77952_i() == 103) {
            if (tag == null) {
                return;
            }
            tooltip.add(QuestTranslation.translate((String)"bq_standard.tooltip.loot_table", (Object[])new Object[]{tag.func_74779_i("loottable")}));
        } else if (stack.func_77952_i() > 101) {
            tooltip.add(QuestTranslation.translate((String)"betterquesting.btn.edit", (Object[])new Object[0]));
        } else if (stack.func_77952_i() == 101) {
            tooltip.add(QuestTranslation.translate((String)"bq_standard.tooltip.loot_chest", (Object[])new Object[]{"???"}));
        } else {
            tooltip.add(QuestTranslation.translate((String)"bq_standard.tooltip.loot_chest", (Object[])new Object[]{MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)100) + "%"}));
        }
    }
}

