/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.net;

import de.maxhenkel.corpse.Death;
import de.maxhenkel.corpse.gui.GUIDeathHistory;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageOpenHistory
implements IMessage,
IMessageHandler<MessageOpenHistory, IMessage> {
    private List<Death> deaths;

    public MessageOpenHistory() {
    }

    public MessageOpenHistory(List<Death> deaths) {
        this.deaths = deaths;
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageOpenHistory message, MessageContext ctx) {
        if (message.deaths.size() > 0) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GUIDeathHistory(message.deaths));
        } else {
            Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentTranslation("message.no_death_history", new Object[0]), true);
        }
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            NBTTagCompound compound = MessageOpenHistory.readTag(buf);
            NBTTagList list = compound.func_150295_c("Deaths", 10);
            this.deaths = new ArrayList<Death>();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.deaths.add(Death.fromNBT(list.func_150305_b(i)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Death d : this.deaths) {
            NBTTagCompound c = d.toNBT(false);
            list.func_74742_a((NBTBase)c);
        }
        compound.func_74782_a("Deaths", (NBTBase)list);
        try {
            MessageOpenHistory.writeTag(buf, compound);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeTag(ByteBuf buf, NBTTagCompound compound) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        CompressedStreamTools.func_74799_a((NBTTagCompound)compound, (OutputStream)outputStream);
        outputStream.flush();
        byte[] data = outputStream.toByteArray();
        outputStream.close();
        buf.writeInt(data.length);
        buf.writeBytes(data);
    }

    public static NBTTagCompound readTag(ByteBuf buf) throws IOException {
        int size = buf.readInt();
        byte[] data = new byte[size];
        buf.readBytes(data);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        inputStream.close();
        return compound;
    }
}

