/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.mod.mixin.core.tileentity;

import io.netty.util.internal.ConcurrentSet;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.block.tileentity.TileEntity;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={net.minecraft.tileentity.TileEntity.class})
public abstract class TileEntityMixin_Forge
implements DataCompoundHolder {
    @Shadow(remap=false)
    private NBTTagCompound customTileData;
    private boolean forge$isGettingTileData = false;
    private static final Set<TileEntityType> FORGEIMPL$REPORTED_RECURSIVE_TILES = new ConcurrentSet();

    @Shadow(remap=false)
    public abstract NBTTagCompound getTileData();

    @Override
    public boolean data$hasRootCompound() {
        return this.customTileData != null;
    }

    @Override
    public NBTTagCompound data$getRootCompound() {
        try {
            if (this.forge$isGettingTileData) {
                this.forge$isGettingTileData = false;
                return this.customTileData;
            }
            this.forge$isGettingTileData = true;
            NBTTagCompound tileData = this.getTileData();
            this.forge$isGettingTileData = false;
            return tileData;
        }
        catch (StackOverflowError error) {
            TileEntityType type = ((TileEntity)((Object)this)).getType();
            if (!FORGEIMPL$REPORTED_RECURSIVE_TILES.contains(type)) {
                FORGEIMPL$REPORTED_RECURSIVE_TILES.add(type);
                PrettyPrinter printer = new PrettyPrinter(60).add("Recursive TileEntity Error").centre().hr().addWrapped(70, "Hi! We're so sorry about this, but, Sponge is not at fault for trying to do things the right way here, but we have a mod that is causing infinite recursion when we're trying to take a snapshot of this TileEntity by overriding getTileData(). Fortunately, we can try to work around this a little, but the mod author must be made aware about the issue as it is an unintended side effect.", new Object[0]).add().add(" %s : %s", "Affected TileEntity Type", type).add().addWrapped(60, "What can be done, however, is provide the offending mod author some information about how to avoid this being printed out. Please link the following:", new Object[0]).table("Explanation", "Link").tr("Initial issue with Jurassicraft", "https://github.com/JurassiCraftTeam/JurassiCraft2/issues/561").tr("MinecraftForge PR adding getTileData()", "https://github.com/MinecraftForge/MinecraftForge/pull/1755").tr("Explanation from Sponge Devs", "https://github.com/JurassiCraftTeam/JurassiCraft2/issues/561#issuecomment-483715610").tr("SpongeForge's Usage of getTileData()", "https://github.com/SpongePowered/SpongeCommon/blob/stable-7/src/main/java/org/spongepowered/common/interfaces/block/tile/IMixinTileEntity.java#L45-L65").tr("Example of incorrect implementation of getTileData()", "https://github.com/JurassiCraftTeam/JurassiCraft2/blob/f2575cfb72008092e6470923c0de9f05f771bfc9/src/main/java/org/jurassicraft/server/block/entity/TourRailBlockEntity.java#L40").add().add("Please remember, this isn't a sponge bug, it's sponge exposing a bug with a mod.").add();
                PhaseTracker.printPhaseStackWithException(PhaseTracker.getInstance(), printer, error);
                printer.log(SpongeImpl.getLogger(), Level.WARN);
            }
            this.customTileData = new NBTTagCompound();
            return this.customTileData;
        }
    }
}

