/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.spongepowered.common.SpongeImpl;

public final class RegistryHelper {
    private static final Field MODIFIERS;

    public static boolean mapFields(Class<?> apiClass, Map<String, ?> mapping) {
        return RegistryHelper.mapFields(apiClass, mapping, null);
    }

    public static boolean mapFields(Class<?> apiClass, Map<String, ?> mapping, @Nullable Set<String> ignoredFields) {
        return RegistryHelper.mapFields(apiClass, (String fieldName) -> mapping.get(fieldName.toLowerCase(Locale.ENGLISH)), ignoredFields);
    }

    public static boolean mapFields(Class<?> apiClass, Function<String, ?> mapFunction) {
        return RegistryHelper.mapFields(apiClass, mapFunction, null);
    }

    public static boolean mapFields(Class<?> apiClass, Function<String, ?> mapFunction, @Nullable Set<String> ignoredFields) {
        boolean mappingSuccess = true;
        boolean custom = !apiClass.getName().startsWith("org.spongepowered.api");
        for (Field f : apiClass.getDeclaredFields()) {
            String fieldName = f.getName();
            if (ignoredFields != null && ignoredFields.contains(fieldName)) continue;
            try {
                Object value = mapFunction.apply(fieldName);
                if (value == null) {
                    value = mapFunction.apply("minecraft:" + fieldName);
                }
                if (value == null) {
                    SpongeImpl.getLogger().warn("Skipping {}.{}", (Object)f.getDeclaringClass().getName(), (Object)fieldName);
                    continue;
                }
                RegistryHelper.setFinalStatic(f, value);
            }
            catch (Exception e) {
                SpongeImpl.getLogger().error("Error while mapping {}.{}", (Object)f.getDeclaringClass().getName(), (Object)fieldName, (Object)e);
                mappingSuccess = false;
            }
        }
        return mappingSuccess;
    }

    public static boolean setFactory(Class<?> apiClass, Object factory) {
        try {
            Field factoryField = apiClass.getDeclaredField("factory");
            RegistryHelper.setFinalStatic(factoryField, factory);
            return true;
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Error while setting factory on {}", apiClass, (Object)e);
            return false;
        }
    }

    public static void setFinalStatic(Class<?> clazz, String fieldName, Object newValue) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            RegistryHelper.setFinalStatic(field, newValue);
        }
        catch (Exception e) {
            SpongeImpl.getLogger().error("Error while setting field {}.{}", (Object)clazz.getName(), (Object)fieldName, (Object)e);
        }
    }

    private static void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        MODIFIERS.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }

    static {
        try {
            MODIFIERS = Field.class.getDeclaredField("modifiers");
            MODIFIERS.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("modifiers field not found", e);
        }
    }
}

