/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.item;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.merge.MergeFunction;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.bridge.data.CustomDataHolderBridge;
import org.spongepowered.common.bridge.world.WorldBridge;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;

@Mixin(value={net.minecraft.item.ItemStack.class})
public abstract class ItemStackMixin
implements CustomDataHolderBridge {
    @Shadow
    private NBTTagCompound field_77990_d;
    private List<DataManipulator<?, ?>> manipulators = Lists.newArrayList();
    private List<DataView> failedData = new ArrayList<DataView>();

    @Shadow
    public abstract boolean shadow$func_190926_b();

    @Shadow
    public abstract NBTTagCompound shadow$func_77978_p();

    @Shadow
    public abstract NBTTagCompound shadow$func_190925_c(String var1);

    @Shadow
    public abstract boolean shadow$func_77942_o();

    @Shadow
    public abstract void shadow$func_77982_d(@Nullable NBTTagCompound var1);

    @Override
    public DataTransactionResult bridge$offerCustom(DataManipulator<?, ?> manipulator, MergeFunction function) {
        if (this.shadow$func_190926_b()) {
            return DataTransactionResult.failResult(manipulator.getValues());
        }
        DataManipulator<?, ?> existingManipulator = null;
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!manipulator.getClass().isInstance(existing)) continue;
            existingManipulator = existing;
            break;
        }
        DataTransactionResult.Builder builder = DataTransactionResult.builder();
        DataManipulator newManipulator = (DataManipulator)Preconditions.checkNotNull((Object)function.merge(existingManipulator, manipulator.copy()));
        if (existingManipulator != null) {
            builder.replace(existingManipulator.getValues());
            this.manipulators.remove(existingManipulator);
        }
        this.manipulators.add(newManipulator);
        this.resyncCustomToTag();
        return builder.success(newManipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
    }

    @Override
    public void bridge$addFailedData(ImmutableList<DataView> failedData) {
        this.failedData.addAll((Collection<DataView>)failedData);
        this.resyncCustomToTag();
    }

    @Override
    public List<DataView> bridge$getFailedData() {
        return this.failedData;
    }

    @Override
    public <T extends DataManipulator<?, ?>> Optional<T> bridge$getCustom(Class<T> customClass) {
        if (this.shadow$func_190926_b()) {
            return Optional.empty();
        }
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!customClass.isInstance(existing)) continue;
            return Optional.of(existing.copy());
        }
        return Optional.empty();
    }

    private void resyncCustomToTag() {
        if (!this.manipulators.isEmpty()) {
            NBTTagList newList = new NBTTagList();
            List<DataView> manipulatorViews = DataUtil.getSerializedManipulatorList(this.bridge$getCustomManipulators());
            for (DataView dataView : manipulatorViews) {
                newList.func_74742_a((NBTBase)NbtTranslator.getInstance().translateData(dataView));
            }
            NBTTagCompound spongeCompound = this.shadow$func_190925_c("SpongeData");
            spongeCompound.func_74782_a("CustomManipulators", (NBTBase)newList);
        } else if (!this.failedData.isEmpty()) {
            NBTTagList newList = new NBTTagList();
            for (DataView failedDatum : this.failedData) {
                newList.func_74742_a((NBTBase)NbtTranslator.getInstance().translateData(failedDatum));
            }
            NBTTagCompound spongeCompound = this.shadow$func_190925_c("SpongeData");
            spongeCompound.func_74782_a("FailedData", (NBTBase)newList);
        } else if (this.shadow$func_77942_o()) {
            this.shadow$func_77978_p().func_82580_o("SpongeData");
            if (this.shadow$func_77978_p().func_82582_d()) {
                this.shadow$func_77982_d(null);
            }
        }
    }

    @Override
    public DataTransactionResult bridge$removeCustom(Class<? extends DataManipulator<?, ?>> customClass) {
        if (this.shadow$func_190926_b()) {
            return DataTransactionResult.failNoData();
        }
        DataManipulator<?, ?> manipulator = null;
        for (DataManipulator<?, ?> existing : this.manipulators) {
            if (!customClass.isInstance(existing)) continue;
            manipulator = existing;
        }
        if (manipulator != null) {
            this.manipulators.remove(manipulator);
            this.resyncCustomToTag();
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public boolean bridge$hasManipulators() {
        return !this.manipulators.isEmpty();
    }

    @Override
    public Collection<DataManipulator<?, ?>> bridge$getCustomManipulators() {
        return this.manipulators.stream().map(DataManipulator::copy).collect(Collectors.toList());
    }

    @Override
    public <E> DataTransactionResult bridge$offerCustom(Key<? extends BaseValue<E>> key, E value) {
        if (this.shadow$func_190926_b()) {
            return DataTransactionResult.failNoData();
        }
        for (DataManipulator<? extends BaseValue<E>, ? extends BaseValue<E>> dataManipulator : this.manipulators) {
            if (!dataManipulator.supports(key)) continue;
            DataTransactionResult.Builder builder = DataTransactionResult.builder();
            builder.replace(((Value)dataManipulator.getValue(key).get()).asImmutable());
            dataManipulator.set(key, value);
            builder.success(((Value)dataManipulator.getValue(key).get()).asImmutable());
            this.resyncCustomToTag();
            return builder.result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failResult(new SpongeValue<E>(key, value).asImmutable());
    }

    @Override
    public DataTransactionResult bridge$removeCustom(Key<?> key) {
        Iterator<DataManipulator<?, ?>> iterator = this.manipulators.iterator();
        while (iterator.hasNext()) {
            DataManipulator<?, ?> manipulator = iterator.next();
            if (manipulator.getKeys().size() != 1 || !manipulator.supports(key)) continue;
            iterator.remove();
            this.resyncCustomToTag();
            return DataTransactionResult.builder().replace(manipulator.getValues()).result(DataTransactionResult.Type.SUCCESS).build();
        }
        return DataTransactionResult.failNoData();
    }

    @Override
    public boolean bridge$supportsCustom(Key<?> key) {
        if (this.shadow$func_190926_b()) {
            return false;
        }
        return this.manipulators.stream().anyMatch(manipulator -> manipulator.supports(key));
    }

    @Override
    public <E> Optional<E> bridge$getCustom(Key<? extends BaseValue<E>> key) {
        if (this.shadow$func_190926_b()) {
            return Optional.empty();
        }
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.get(key));
    }

    @Override
    public <E, V extends BaseValue<E>> Optional<V> bridge$getCustomValue(Key<V> key) {
        if (this.shadow$func_190926_b()) {
            return Optional.empty();
        }
        return this.manipulators.stream().filter(manipulator -> manipulator.supports(key)).findFirst().flatMap(supported -> supported.getValue(key));
    }

    @Inject(method={"copy"}, at={@At(value="RETURN")})
    private void impl$copySpongeDataOnSplit(CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        net.minecraft.item.ItemStack itemStack = info.getReturnValue();
        if (this.bridge$hasManipulators()) {
            for (DataManipulator<?, ?> manipulator : this.manipulators) {
                ((CustomDataHolderBridge)itemStack).bridge$offerCustom((DataManipulator<?, ?>)manipulator.copy(), MergeFunction.IGNORE_ALL);
            }
        }
    }

    @Inject(method={"splitStack"}, at={@At(value="RETURN")})
    private void impl$copySpongeDataOnSplit(int amount, CallbackInfoReturnable<net.minecraft.item.ItemStack> info) {
        net.minecraft.item.ItemStack itemStack = info.getReturnValue();
        if (this.bridge$hasManipulators()) {
            for (DataManipulator<?, ?> manipulator : this.manipulators) {
                ((CustomDataHolderBridge)itemStack).bridge$offerCustom((DataManipulator<?, ?>)manipulator.copy(), MergeFunction.IGNORE_ALL);
            }
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/nbt/NBTTagCompound;)V"}, at={@At(value="RETURN")})
    private void impl$onRead(NBTTagCompound compound, CallbackInfo info) {
        if (this.shadow$func_77942_o() && this.shadow$func_77978_p().func_150297_b("SpongeData", 10)) {
            DataUtil.readCustomData(this.shadow$func_77978_p().func_74775_l("SpongeData"), (ItemStack)((Object)this));
        }
        if (this.field_77990_d != null && this.field_77990_d.func_82582_d()) {
            this.field_77990_d = null;
        }
    }

    @Redirect(method={"removeSubCompound"}, at=@At(value="INVOKE", target="Lnet/minecraft/nbt/NBTTagCompound;removeTag(Ljava/lang/String;)V"))
    private void impl$nullStackCompoundIfEmptyAfterRemoval(NBTTagCompound compound, String key) {
        compound.func_82580_o(key);
        if (compound.func_82582_d()) {
            this.field_77990_d = null;
        }
    }

    @Inject(method={"setTagCompound"}, at={@At(value="RETURN")})
    private void impl$onSet(NBTTagCompound compound, CallbackInfo callbackInfo) {
        if (this.field_77990_d != compound) {
            this.manipulators.clear();
        }
        if (this.shadow$func_77942_o() && this.shadow$func_77978_p().func_150297_b("SpongeData", 10)) {
            DataUtil.readCustomData(this.shadow$func_77978_p().func_74775_l("SpongeData"), (ItemStack)((Object)this));
        }
    }

    @Inject(method={"onBlockDestroyed"}, at={@At(value="HEAD")})
    private void impl$capturePlayerUsingItemstack(World worldIn, IBlockState blockIn, BlockPos pos, EntityPlayer playerIn, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake()) {
            PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
            IPhaseState state = currentContext.state;
            state.capturePlayerUsingStackToBreakBlock((ItemStack)((Object)this), (EntityPlayerMP)playerIn, currentContext);
        }
    }

    @Inject(method={"onBlockDestroyed"}, at={@At(value="RETURN")})
    private void impl$nullOutCapturedPlayer(World worldIn, IBlockState blockIn, BlockPos pos, EntityPlayer playerIn, CallbackInfo ci) {
        if (!((WorldBridge)worldIn).bridge$isFake()) {
            PhaseContext<?> currentContext = PhaseTracker.getInstance().getCurrentContext();
            IPhaseState state = currentContext.state;
            state.capturePlayerUsingStackToBreakBlock((ItemStack)((Object)this), null, currentContext);
        }
    }
}

