/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.entity.living.human;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketSpawnPlayer;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameType;
import net.minecraft.world.World;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.scoreboard.TeamMember;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.bridge.data.DataCompoundHolder;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.mixin.core.entity.EntityLivingBaseAccessor;
import org.spongepowered.common.mixin.core.entity.player.EntityPlayerAccessor;
import org.spongepowered.common.mixin.core.network.play.server.SPacketPlayerListItemAccessor;
import org.spongepowered.common.mixin.core.network.play.server.SPacketSpawnPlayerAccessor;

public class EntityHuman
extends EntityCreature
implements TeamMember,
IRangedAttackMob {
    private static final LoadingCache<UUID, PropertyMap> PROPERTIES_CACHE = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<UUID, PropertyMap>(){

        public PropertyMap load(UUID uuid) throws Exception {
            return SpongeImpl.getServer().func_147130_as().fillProfileProperties(new GameProfile(uuid, ""), true).getProperties();
        }
    });
    private final Map<UUID, List<Packet<?>[]>> playerPacketMap = Maps.newHashMap();
    private GameProfile fakeProfile = new GameProfile(this.field_96093_i, "");
    @Nullable
    private UUID skinUuid;
    private boolean aiDisabled = false;
    private boolean leftHanded = false;

    public EntityHuman(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        this.func_98053_h(true);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(EntityLivingBaseAccessor.accessor$getHandStatesParameter(), (Object)0);
        this.field_70180_af.func_187214_a(EntityLivingBaseAccessor.accessor$getPotionEffectsParameter(), (Object)0);
        this.field_70180_af.func_187214_a(EntityLivingBaseAccessor.accessor$getHideParticlesParameter(), (Object)false);
        this.field_70180_af.func_187214_a(EntityLivingBaseAccessor.accessor$getArrowCountInEntityParameter(), (Object)0);
        this.field_70180_af.func_187214_a(EntityLivingBaseAccessor.accessor$getHealthParameter(), (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(EntityPlayerAccessor.accessor$getAbsorptionParameter(), (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(EntityPlayerAccessor.accessor$getPlayerScoreParameter(), (Object)0);
        this.field_70180_af.func_187214_a(EntityPlayerAccessor.accessor$getPlayerModelFlagParameter(), (Object)0);
        this.field_70180_af.func_187214_a(EntityPlayerAccessor.accessor$getMainHandParameter(), (Object)1);
    }

    public boolean func_184638_cS() {
        return this.leftHanded;
    }

    public boolean func_175446_cd() {
        return this.aiDisabled;
    }

    @Override
    public Text getTeamRepresentation() {
        return Text.of(this.fakeProfile.getName());
    }

    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.fakeProfile.getName());
    }

    public void func_96094_a(String name) {
        if (name.length() > 16) {
            name = name.substring(0, 16);
        }
        if (this.func_95999_t().equals(name)) {
            return;
        }
        super.func_96094_a(name);
        this.renameProfile(name);
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        super.func_70037_a(tagCompund);
        String skinUuidString = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound().func_74779_i("skinUuid");
        if (!skinUuidString.isEmpty()) {
            this.updateFakeProfileWithSkin(UUID.fromString(skinUuidString));
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        NBTTagCompound spongeData = ((DataCompoundHolder)((Object)this)).data$getSpongeCompound();
        if (this.skinUuid != null) {
            spongeData.func_74778_a("skinUuid", this.skinUuid.toString());
        } else {
            spongeData.func_82580_o("skinUuid");
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.func_82168_bl();
    }

    public void func_94061_f(boolean disable) {
        this.aiDisabled = disable;
    }

    public void func_184641_n(boolean leftHanded) {
        this.leftHanded = leftHanded;
    }

    public int func_82145_z() {
        return 80;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187808_ef;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_187806_ee;
    }

    public int func_82147_ab() {
        return 10;
    }

    public void func_70645_a(@Nullable DamageSource cause) {
        super.func_70645_a(cause);
        this.func_70105_a(0.2f, 0.2f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70181_x = 0.1;
        if (cause != null) {
            this.field_70159_w = -MathHelper.func_76134_b((float)((this.field_70739_aP + this.field_70177_z) * (float)Math.PI / 180.0f)) * 0.1f;
            this.field_70179_y = -MathHelper.func_76126_a((float)((this.field_70739_aP + this.field_70177_z) * (float)Math.PI / 180.0f)) * 0.1f;
        } else {
            this.field_70179_y = 0.0;
            this.field_70159_w = 0.0;
        }
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187800_eb;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187798_ea;
    }

    public double func_70033_W() {
        return -0.35;
    }

    public float func_70689_ay() {
        return (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
    }

    protected SoundEvent func_184588_d(int height) {
        return height > 4 ? SoundEvents.field_187736_dY : SoundEvents.field_187804_ed;
    }

    public float func_70047_e() {
        return 1.62f;
    }

    public float func_110139_bj() {
        return ((Float)this.func_184212_Q().func_187225_a(EntityPlayerAccessor.accessor$getAbsorptionParameter())).floatValue();
    }

    public void func_110149_m(float amount) {
        if (amount < 0.0f) {
            amount = 0.0f;
        }
        this.func_184212_Q().func_187227_b(EntityPlayerAccessor.accessor$getAbsorptionParameter(), (Object)Float.valueOf(amount));
    }

    protected float func_110146_f(float p_110146_1_, float p_110146_2_) {
        float retValue = super.func_110146_f(p_110146_1_, p_110146_2_);
        this.field_70177_z = this.field_70759_as;
        return retValue;
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag;
        super.func_70652_k(entityIn);
        this.func_184609_a(EnumHand.MAIN_HAND);
        float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int i = 0;
        if (entityIn instanceof EntityLivingBase) {
            f += EnchantmentHelper.func_152377_a((ItemStack)this.func_184586_b(EnumHand.MAIN_HAND), (EnumCreatureAttribute)((EntityLivingBase)entityIn).func_70668_bt());
            i += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (flag = entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), f)) {
            int j;
            if (i > 0) {
                entityIn.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((j = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                entityIn.func_70015_d(j * 4);
            }
            this.func_174815_a((EntityLivingBase)this, entityIn);
        }
        return flag;
    }

    private void renameProfile(String newName) {
        PropertyMap props = this.fakeProfile.getProperties();
        this.fakeProfile = new GameProfile(this.fakeProfile.getId(), newName);
        this.fakeProfile.getProperties().putAll((Multimap)props);
    }

    private boolean updateFakeProfileWithSkin(UUID skin) {
        PropertyMap properties = (PropertyMap)PROPERTIES_CACHE.getUnchecked((Object)skin);
        if (properties.isEmpty()) {
            return false;
        }
        this.fakeProfile.getProperties().replaceValues((Object)"textures", (Iterable)properties.get((Object)"textures"));
        this.skinUuid = skin;
        return true;
    }

    public void removeFromTabListDelayed(@Nullable EntityPlayerMP player, SPacketPlayerListItem removePacket) {
        int delay = SpongeImpl.getGlobalConfigAdapter().getConfig().getEntity().getHumanPlayerListRemoveDelay();
        Runnable removeTask = () -> this.pushPackets(player, new Packet[]{removePacket});
        if (delay == 0) {
            removeTask.run();
        } else {
            SpongeImpl.getGame().getScheduler().createTaskBuilder().execute(removeTask).delayTicks(delay).submit(SpongeImpl.getPlugin());
        }
    }

    public boolean setSkinUuid(UUID skin) {
        if (!SpongeImpl.getServer().func_71266_T()) {
            return false;
        }
        if (skin.equals(this.skinUuid)) {
            return true;
        }
        if (!this.updateFakeProfileWithSkin(skin)) {
            return false;
        }
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return true;
    }

    @Nullable
    public UUID getSkinUuid() {
        return this.skinUuid;
    }

    public DataTransactionResult removeSkin() {
        if (this.skinUuid == null) {
            return DataTransactionResult.successNoData();
        }
        this.fakeProfile.getProperties().removeAll((Object)"textures");
        ImmutableSpongeValue<UUID> oldValue = new ImmutableSpongeValue<UUID>(Keys.SKIN_UNIQUE_ID, this.skinUuid);
        this.skinUuid = null;
        if (this.isAliveAndInWorld()) {
            this.respawnOnClient();
        }
        return DataTransactionResult.builder().result(DataTransactionResult.Type.SUCCESS).replace(oldValue).build();
    }

    private boolean isAliveAndInWorld() {
        return this.field_70170_p.func_73045_a(this.func_145782_y()) == this && !this.field_70128_L;
    }

    private void respawnOnClient() {
        this.pushPackets(new Packet[]{new SPacketDestroyEntities(new int[]{this.func_145782_y()}), this.createPlayerListPacket(SPacketPlayerListItem.Action.ADD_PLAYER)});
        this.pushPackets(new Packet[]{this.createSpawnPacket()});
        this.removeFromTabListDelayed(null, this.createPlayerListPacket(SPacketPlayerListItem.Action.REMOVE_PLAYER));
    }

    public boolean canRemoveFromListImmediately() {
        return !this.fakeProfile.getProperties().containsKey((Object)"textures");
    }

    public void onRemovedFrom(EntityPlayerMP player) {
        this.playerPacketMap.remove(player.func_110124_au());
        player.field_71135_a.func_147359_a((Packet)this.createPlayerListPacket(SPacketPlayerListItem.Action.REMOVE_PLAYER));
    }

    public SPacketSpawnPlayer createSpawnPacket() {
        SPacketSpawnPlayer packet = new SPacketSpawnPlayer();
        SPacketSpawnPlayerAccessor accessor = (SPacketSpawnPlayerAccessor)packet;
        accessor.accessor$setentityId(this.func_145782_y());
        accessor.accessor$setuniqueId(this.fakeProfile.getId());
        accessor.accessor$setx(this.field_70165_t);
        accessor.accessor$sety(this.field_70163_u);
        accessor.accessor$setZ(this.field_70161_v);
        accessor.accessor$setYaw((byte)(this.field_70177_z * 256.0f / 360.0f));
        accessor.accessor$setPitch((byte)(this.field_70125_A * 256.0f / 360.0f));
        accessor.accessor$setWatcher(this.func_184212_Q());
        return packet;
    }

    public SPacketPlayerListItem createPlayerListPacket(SPacketPlayerListItem.Action action) {
        SPacketPlayerListItem packet = new SPacketPlayerListItem(action, new EntityPlayerMP[0]);
        List<SPacketPlayerListItem.AddPlayerData> list = ((SPacketPlayerListItemAccessor)packet).accessor$getPlayerDatas();
        SPacketPlayerListItem sPacketPlayerListItem = packet;
        sPacketPlayerListItem.getClass();
        list.add(new SPacketPlayerListItem.AddPlayerData(sPacketPlayerListItem, this.fakeProfile, 0, GameType.NOT_SET, this.func_145748_c_()));
        return packet;
    }

    public void pushPackets(Packet<?> ... packets) {
        this.pushPackets((EntityPlayerMP)null, packets);
    }

    public void pushPackets(@Nullable EntityPlayerMP player, Packet<?> ... packets) {
        if (player == null) {
            List<Packet<?>[]> queue = this.playerPacketMap.get(null);
            if (queue == null) {
                queue = new ArrayList<Packet<?>[]>();
                this.playerPacketMap.put(null, queue);
            }
            queue.add(packets);
        } else {
            List<Packet<?>[]> queue = this.playerPacketMap.get(player.func_110124_au());
            if (queue == null) {
                queue = new ArrayList<Packet<?>[]>();
                this.playerPacketMap.put(player.func_110124_au(), queue);
            }
            queue.add(packets);
        }
    }

    public Packet<?>[] popQueuedPackets(@Nullable EntityPlayerMP player) {
        List<Packet<?>[]> queue = this.playerPacketMap.get(player == null ? null : player.func_110124_au());
        return queue == null || queue.isEmpty() ? null : queue.remove(0);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        ItemStack itemstack;
        EntityTippedArrow entitytippedarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entitytippedarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entitytippedarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)this);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)this);
        entitytippedarrow.func_70239_b((double)(distanceFactor * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            entitytippedarrow.func_70239_b(entitytippedarrow.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            entitytippedarrow.func_70240_a(j);
        }
        if ((itemstack = this.func_184586_b(EnumHand.OFF_HAND)).func_77973_b() == Items.field_185167_i) {
            entitytippedarrow.func_184555_a(itemstack);
        }
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entitytippedarrow);
    }

    public void func_184724_a(boolean var1) {
    }
}

