/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.builder.block.tileentity;

import java.util.Optional;
import net.minecraft.tileentity.TileEntityBrewingStand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.tileentity.carrier.BrewingStand;
import org.spongepowered.api.data.DataQuery;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.manipulator.mutable.tileentity.BrewingStandData;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.common.data.builder.block.tileentity.SpongeLockableBuilder;
import org.spongepowered.common.util.Constants;

public class SpongeBrewingStandBuilder
extends SpongeLockableBuilder<BrewingStand> {
    public static final DataQuery BREW_TIME_QUERY = DataQuery.of("BrewTime");

    public SpongeBrewingStandBuilder() {
        super(BrewingStand.class, 1);
    }

    @Override
    protected Optional<BrewingStand> buildContent(DataView container) throws InvalidDataException {
        return super.buildContent(container).map(brewingStand -> {
            if (!container.contains(BREW_TIME_QUERY)) {
                throw new InvalidDataException("The provided container does not contain the data to make a Banner!");
            }
            if (container.contains(Constants.TileEntity.CUSTOM_NAME)) {
                ((TileEntityBrewingStand)brewingStand).func_145937_a(container.getString(Constants.TileEntity.CUSTOM_NAME).get());
            }
            BrewingStandData brewingData = Sponge.getDataManager().getManipulatorBuilder(BrewingStandData.class).get().create();
            brewingData.remainingBrewTime().set(container.getInt(BREW_TIME_QUERY).get());
            brewingStand.offer(brewingData);
            ((TileEntityBrewingStand)brewingStand).func_145829_t();
            return brewingStand;
        });
    }
}

