/*
 * Decompiled with CFR 0.152.
 */
package com.nicjames2378.bqforestry.utils;

import java.util.Arrays;

public class StringUtils {
    public static int indexOfFirstCapital(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    public static String capitalizeFirst(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }

    public static String padInMiddle(String a, String b, int totalLength) {
        if (a.length() + b.length() > totalLength) {
            return a.concat(StringUtils.getSpaces(3)).concat(b);
        }
        int remaining = totalLength - a.length() - b.length();
        return a + StringUtils.getSpaces(remaining) + b;
    }

    private static String getSpaces(int amount) {
        return StringUtils.getCharacterRepeated(' ', amount);
    }

    private static String getCharacterRepeated(char character, int amount) {
        return new String(new char[amount]).replace('\u0000', character);
    }

    public static String flattenArray(String[] arr) {
        return StringUtils.flattenArray(arr, ", ", null);
    }

    public static String flattenArray(String[] arr, String divider) {
        return StringUtils.flattenArray(arr, divider, null);
    }

    public static String flattenArray(String[] arr, String divider, IStringStyle style) {
        if (divider == null) {
            divider = "";
        }
        if (arr == null || Arrays.toString(arr).equals("[]")) {
            return "Any";
        }
        int iMax = arr.length - 1;
        if (iMax == -1) {
            return "Any";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            if (style == null) {
                b.append(arr[i]);
            } else {
                b.append(style.stylize(arr[i]));
            }
            if (i == iMax) {
                return b.toString();
            }
            b.append(divider);
            ++i;
        }
    }

    public static int getCount(String string, String substring) {
        int lastIndex = 0;
        int count = 0;
        while (lastIndex != -1) {
            if ((lastIndex = string.indexOf(substring, lastIndex)) == -1) continue;
            ++count;
            lastIndex += substring.length();
        }
        return count;
    }

    public static interface IStringStyle {
        public String stylize(String var1);
    }
}

