/*
 * Decompiled with CFR 0.152.
 */
package de.randombyte.lottery.shaded.kosp.config.serializers.text;

import com.google.common.collect.ImmutableList;
import de.randombyte.lottery.shaded.kosp.config.serializers.RegexKt;
import de.randombyte.lottery.shaded.kosp.config.serializers.StringPart;
import de.randombyte.lottery.shaded.kosp.config.serializers.UtilsKt;
import de.randombyte.lottery.shaded.kosp.config.serializers.text.SimpleTextTypeSerializer;
import de.randombyte.lottery.shaded.kosp.config.serializers.text.SimpleTextTypeSerializerKt;
import de.randombyte.lottery.shaded.kosp.extensions.TextsKt;
import de.randombyte.lottery.shaded.kotlin.Metadata;
import de.randombyte.lottery.shaded.kotlin.NoWhenBranchMatchedException;
import de.randombyte.lottery.shaded.kotlin.TypeCastException;
import de.randombyte.lottery.shaded.kotlin.collections.CollectionsKt;
import de.randombyte.lottery.shaded.kotlin.jvm.internal.Intrinsics;
import de.randombyte.lottery.shaded.kotlin.text.StringsKt;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextFormat;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u001c\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0002J\f\u0010\u0010\u001a\u00020\u0004*\u00020\u0004H\u0002\u00a8\u0006\u0011"}, d2={"Lde/randombyte/lottery/shaded/kosp/config/serializers/text/SimpleTextDeserializer;", "", "()V", "deserialize", "Lorg/spongepowered/api/text/Text;", "string", "", "deserialize$kosp", "deserializeWithResetCode", "textString", "fixTextFormatting", "", "texts", "parseLinksAndText", "isContentEmpty", "", "simplify", "kosp"})
public final class SimpleTextDeserializer {
    public static final SimpleTextDeserializer INSTANCE;

    @NotNull
    public final Text deserialize$kosp(@NotNull String string) {
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull(string, "string");
        List<Text> texts = this.parseLinksAndText(string);
        Collection collection = $receiver$iv = (Collection)texts;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        Text[] textArray = thisCollection$iv.toArray(new Text[thisCollection$iv.size()]);
        if (textArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Text text = Text.of((Object[])Arrays.copyOf(textArray, textArray.length));
        Intrinsics.checkExpressionValueIsNotNull(text, "Text.of(*texts.toTypedArray())");
        return text;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Text> parseLinksAndText(String string) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)CollectionsKt.toList((Iterable)UtilsKt.categorizeByIsMatchingRegex(string, RegexKt.getMARKDOWN_LINK_REGEX()));
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Text text;
            void it;
            StringPart stringPart = (StringPart)item$iv$iv;
            Collection collection = destination$iv$iv;
            void var9_9 = it;
            if (var9_9 instanceof StringPart.Matching) {
                ClickAction clickAction;
                String linkText = ((StringPart.Matching)it).getMatchResult().getGroupValues().get(1);
                String linkDestination = ((StringPart.Matching)it).getMatchResult().getGroupValues().get(2);
                if (StringsKt.startsWith$default(linkDestination, "&", false, 2, null)) {
                    clickAction = (ClickAction)TextActions.suggestCommand((String)StringsKt.removePrefix(linkDestination, (CharSequence)"&"));
                } else if (StringsKt.startsWith$default(linkDestination, "/", false, 2, null)) {
                    clickAction = (ClickAction)TextActions.runCommand((String)linkDestination);
                } else {
                    ClickAction.OpenUrl openUrl;
                    try {
                        openUrl = TextActions.openUrl((URL)new URL(linkDestination));
                    }
                    catch (MalformedURLException exception) {
                        throw (Throwable)new RuntimeException("TextAction couldn't be parsed: '" + linkDestination + "' invalid!", exception);
                    }
                    clickAction = (ClickAction)openUrl;
                }
                ClickAction clickAction2 = clickAction;
                text = TextsKt.action(INSTANCE.simplify(INSTANCE.deserializeWithResetCode(linkText)), (TextAction)clickAction2);
            } else if (var9_9 instanceof StringPart.NotMatching) {
                text = INSTANCE.deserializeWithResetCode(((StringPart.NotMatching)it).getString());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Text text2 = text;
            collection.add(text2);
        }
        List texts = (List)destination$iv$iv;
        List<Text> fixedFormatsTexts = this.fixTextFormatting(texts);
        return fixedFormatsTexts;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Text> fixTextFormatting(List<? extends Text> texts) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        TextFormat textFormat = TextFormat.NONE;
        Intrinsics.checkExpressionValueIsNotNull(textFormat, "TextFormat.NONE");
        TextFormat lastTextFormat = textFormat;
        Iterable iterable = $receiver$iv = (Iterable)texts;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Text text;
            void text2;
            Text text3 = (Text)item$iv$iv;
            Collection collection = destination$iv$iv;
            if (!SimpleTextTypeSerializerKt.hasAction((Text)text2)) {
                TextFormat currentFormat = UtilsKt.getLastFormat((Text)text2);
                if (Intrinsics.areEqual(currentFormat, TextFormat.NONE) ^ true) {
                    lastTextFormat = currentFormat;
                    text = text2;
                } else {
                    text = TextsKt.format((Text)text2, lastTextFormat);
                }
            } else {
                text = text2;
            }
            void var11_11 = text;
            collection.add(var11_11);
        }
        return (List)destination$iv$iv;
    }

    private final Text deserializeWithResetCode(String textString) {
        Text text;
        if (!StringsKt.contains$default((CharSequence)textString, SimpleTextTypeSerializer.INSTANCE.getRESET_CODE$kosp(), false, 2, null)) {
            return de.randombyte.lottery.shaded.kosp.extensions.StringsKt.deserialize(textString, false);
        }
        String[] stringArray = new String[1];
        stringArray[0] = SimpleTextTypeSerializer.INSTANCE.getRESET_CODE$kosp();
        String[] stringArray2 = stringArray;
        boolean bl = false;
        int n = 2;
        List splits = StringsKt.split$default((CharSequence)textString, stringArray2, bl, n, 2, null);
        String splitBeforeReset = (String)splits.get(0);
        String splitAfterReset = (String)splits.get(1);
        Text firstText = de.randombyte.lottery.shaded.kosp.extensions.StringsKt.deserialize(splitBeforeReset, false);
        Text secondText = TextsKt.reset(de.randombyte.lottery.shaded.kosp.extensions.StringsKt.deserialize(splitAfterReset, false));
        if (this.isContentEmpty(firstText)) {
            text = secondText;
        } else if (this.isContentEmpty(secondText)) {
            text = firstText;
        } else {
            Text text2 = Text.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull(text2, "Text.EMPTY");
            text = TextsKt.plus(TextsKt.plus(text2, firstText), secondText);
        }
        return text;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Text simplify(@NotNull Text $receiver) {
        Text text;
        if ($receiver.getChildren().size() == 1 && $receiver instanceof LiteralText) {
            String string = ((LiteralText)$receiver).getContent();
            Intrinsics.checkExpressionValueIsNotNull(string, "content");
            CharSequence charSequence = string;
            if (charSequence.length() == 0 && Intrinsics.areEqual(((LiteralText)$receiver).getFormat(), TextFormat.NONE)) {
                Optional optional = ((LiteralText)$receiver).getClickAction();
                Intrinsics.checkExpressionValueIsNotNull(optional, "clickAction");
                if (!optional.isPresent()) {
                    Optional optional2 = ((LiteralText)$receiver).getShiftClickAction();
                    Intrinsics.checkExpressionValueIsNotNull(optional2, "shiftClickAction");
                    if (!optional2.isPresent()) {
                        Optional optional3 = ((LiteralText)$receiver).getHoverAction();
                        Intrinsics.checkExpressionValueIsNotNull(optional3, "hoverAction");
                        if (!optional3.isPresent()) {
                            ImmutableList immutableList = ((LiteralText)$receiver).getChildren();
                            Intrinsics.checkExpressionValueIsNotNull(immutableList, "children");
                            Object t = CollectionsKt.first((List)immutableList);
                            Intrinsics.checkExpressionValueIsNotNull(t, "children.first()");
                            text = (Text)t;
                            return text;
                        }
                    }
                }
            }
        }
        text = $receiver;
        return text;
    }

    private final boolean isContentEmpty(@NotNull Text $receiver) {
        String string = $receiver.toPlain();
        Intrinsics.checkExpressionValueIsNotNull(string, "toPlain()");
        CharSequence charSequence = string;
        return charSequence.length() == 0;
    }

    private SimpleTextDeserializer() {
    }

    static {
        SimpleTextDeserializer simpleTextDeserializer;
        INSTANCE = simpleTextDeserializer = new SimpleTextDeserializer();
    }
}

