/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.services.impl.storage;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.configurate.AbstractConfigurateBackedDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.GeneralDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.UserDataObject;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.WorldDataObject;
import io.github.nucleuspowered.storage.dataobjects.keyed.AbstractKeyBasedDataObject;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DataObjectTranslator
implements TypeSerializer<AbstractConfigurateBackedDataObject> {
    public static final DataObjectTranslator INSTANCE = new DataObjectTranslator();

    private DataObjectTranslator() {
    }

    public @Nullable AbstractConfigurateBackedDataObject deserialize(@NonNull TypeToken<?> type, @NonNull ConfigurationNode value) throws ObjectMappingException {
        AbstractKeyBasedDataObject ado = null;
        if (type.isSupertypeOf(UserDataObject.class)) {
            ado = new UserDataObject();
        } else if (type.isSupertypeOf(WorldDataObject.class)) {
            ado = new WorldDataObject();
        } else if (type.isSupertypeOf(GeneralDataObject.class)) {
            ado = new GeneralDataObject();
        }
        if (ado != null) {
            ((AbstractConfigurateBackedDataObject)ado).setBackingNode(value);
        }
        return ado;
    }

    public void serialize(@NonNull TypeToken<?> type, @Nullable AbstractConfigurateBackedDataObject obj, @NonNull ConfigurationNode value) throws ObjectMappingException {
        if (obj != null) {
            value.setValue((Object)obj.getBackingNode());
        }
    }
}

