/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command.parameter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.ArgumentParseException;
import org.spongepowered.api.command.args.CommandArgs;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.text.Text;

public class ImprovedGameModeArgument
extends CommandElement {
    private static final Map<String, GameMode> GAMEMODE_MAP = Maps.newHashMap();
    private final IMessageProviderService messageProviderService;

    public ImprovedGameModeArgument(@Nullable Text key, INucleusServiceCollection serviceCollection) {
        super(key);
        this.messageProviderService = serviceCollection.messageProvider();
    }

    @Nullable
    protected Object parseValue(CommandSource source, CommandArgs args) throws ArgumentParseException {
        String arg = args.next();
        GameMode mode = GAMEMODE_MAP.get(arg.toLowerCase());
        if (mode == null) {
            throw args.createError(this.messageProviderService.getMessageFor(source, "args.gamemode.error", arg));
        }
        return mode;
    }

    public List<String> complete(CommandSource src, CommandArgs args, CommandContext context) {
        try {
            String arg = args.peek();
            return GAMEMODE_MAP.keySet().stream().filter(x -> x.startsWith(arg.toLowerCase())).collect(Collectors.toList());
        }
        catch (ArgumentParseException e) {
            return Lists.newArrayList(GAMEMODE_MAP.keySet());
        }
    }

    public Text getUsage(CommandSource src) {
        return Text.of((String)"game mode");
    }

    static {
        GAMEMODE_MAP.put("survival", GameModes.SURVIVAL);
        GAMEMODE_MAP.put("s", GameModes.SURVIVAL);
        GAMEMODE_MAP.put("su", GameModes.SURVIVAL);
        GAMEMODE_MAP.put("0", GameModes.SURVIVAL);
        GAMEMODE_MAP.put("creative", GameModes.CREATIVE);
        GAMEMODE_MAP.put("c", GameModes.CREATIVE);
        GAMEMODE_MAP.put("1", GameModes.CREATIVE);
        GAMEMODE_MAP.put("adventure", GameModes.ADVENTURE);
        GAMEMODE_MAP.put("a", GameModes.ADVENTURE);
        GAMEMODE_MAP.put("2", GameModes.ADVENTURE);
        GAMEMODE_MAP.put("spectator", GameModes.SPECTATOR);
        GAMEMODE_MAP.put("sp", GameModes.SPECTATOR);
        GAMEMODE_MAP.put("3", GameModes.SPECTATOR);
    }
}

