/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.scaffold.command;

import io.github.nucleuspowered.nucleus.scaffold.command.parameter.DisplayNameArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.GameProfileArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.NucleusWorldPropertiesArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.SelectorArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.TimespanArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.parameter.UUIDArgument;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import javax.annotation.Nullable;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.Living;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;

public class NucleusParameters {
    public static final CommandElement ONE_TRUE_FALSE = GenericArguments.onlyOne((CommandElement)GenericArguments.bool((Text)Text.of((String)"true|false")));
    public static final CommandElement OPTIONAL_ONE_TRUE_FALSE = GenericArguments.optional((CommandElement)ONE_TRUE_FALSE);
    public static final LazyLoadedCommandElement MANY_ENTITY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new SelectorArgument(new DisplayNameArgument((Text)Text.of((String)"subject"), DisplayNameArgument.Target.PLAYER, serviceCollection), Entity.class, serviceCollection);
        }
    };
    public static final LazyLoadedCommandElement MANY_LIVING = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new SelectorArgument(new DisplayNameArgument((Text)Text.of((String)"subject"), DisplayNameArgument.Target.PLAYER, serviceCollection), Living.class, serviceCollection);
        }
    };
    private static final LazyLoadedCommandElement MANY_PLAYER_NO_SELECTOR = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new DisplayNameArgument((Text)Text.of((String)"player"), DisplayNameArgument.Target.PLAYER, serviceCollection);
        }
    };
    public static final LazyLoadedCommandElement MANY_USER_NO_SELECTOR = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new DisplayNameArgument((Text)Text.of((String)"user"), DisplayNameArgument.Target.USER, serviceCollection);
        }
    };
    public static final LazyLoadedCommandElement ONE_PLAYER_NO_SELECTOR = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)MANY_PLAYER_NO_SELECTOR.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement MANY_PLAYER = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new SelectorArgument(MANY_PLAYER_NO_SELECTOR.get(serviceCollection), Player.class, serviceCollection);
        }
    };
    public static final LazyLoadedCommandElement ONE_PLAYER = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)MANY_PLAYER.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement OPTIONAL_ONE_PLAYER = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.optionalWeak((CommandElement)ONE_PLAYER.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement MANY_PLAYER_OR_CONSOLE = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new SelectorArgument(new DisplayNameArgument((Text)Text.of((String)"player|-"), DisplayNameArgument.Target.PLAYER, serviceCollection), Player.class, serviceCollection);
        }
    };
    public static final LazyLoadedCommandElement ONE_PLAYER_OR_CONSOLE = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)MANY_PLAYER_OR_CONSOLE.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement ONE_USER = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)new SelectorArgument(new DisplayNameArgument((Text)Text.of((String)"user"), DisplayNameArgument.Target.USER, serviceCollection), Player.class, serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement ONE_USER_UUID = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne(UUIDArgument.user((Text)Text.of((String)"user uuid"), serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement ONE_USER_PLAYER_KEY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)new SelectorArgument(new DisplayNameArgument((Text)Text.of((String)"player"), DisplayNameArgument.Target.USER, serviceCollection), Player.class, serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement ONE_GAME_PROFILE_UUID = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne(UUIDArgument.gameProfile((Text)Text.of((String)"user uuid"), serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement ONE_GAME_PROFILE = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)new GameProfileArgument((Text)Text.of((String)"user"), serviceCollection));
        }
    };
    public static final CommandElement COMMAND = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"command"));
    public static final CommandElement OPTIONAL_COMMAND = GenericArguments.optional((CommandElement)COMMAND);
    public static final CommandElement DESCRIPTION = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"description"));
    public static final CommandElement OPTIONAL_DESCRIPTION = GenericArguments.optional((CommandElement)DESCRIPTION);
    public static final CommandElement LORE = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"lore"));
    public static final CommandElement MESSAGE = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"message"));
    public static final CommandElement OPTIONAL_MESSAGE = GenericArguments.optional((CommandElement)MESSAGE);
    public static final CommandElement REASON = GenericArguments.remainingRawJoinedStrings((Text)Text.of((String)"reason"));
    public static final CommandElement OPTIONAL_REASON = GenericArguments.optional((CommandElement)REASON);
    public static final LazyLoadedCommandElement WORLD_PROPERTIES_ENABLED_ONLY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.ENABLED_ONLY, serviceCollection);
        }
    };
    public static final LazyLoadedCommandElement OPTIONAL_WEAK_WORLD_PROPERTIES_ENABLED_ONLY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.optionalWeak((CommandElement)WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement OPTIONAL_WORLD_PROPERTIES_ENABLED_ONLY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.optional((CommandElement)WORLD_PROPERTIES_ENABLED_ONLY.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement WORLD_PROPERTIES_DISABLED_ONLY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.DISABLED_ONLY, serviceCollection);
        }
    };
    public static final LazyLoadedCommandElement WORLD_PROPERTIES_ALL = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.ALL, serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement OPTIONAL_WORLD_PROPERTIES_ALL = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.optionalWeak((CommandElement)WORLD_PROPERTIES_ALL.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement WORLD_PROPERTIES_UNLOADED_ONLY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.UNLOADED_ONLY, serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement WORLD_PROPERTIES_LOADED_ONLY = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)new NucleusWorldPropertiesArgument((Text)Text.of((String)"world"), NucleusWorldPropertiesArgument.Type.LOADED_ONLY, serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement DURATION = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.onlyOne((CommandElement)new TimespanArgument((Text)Text.of((String)"duration"), serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement OPTIONAL_DURATION = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.optional((CommandElement)DURATION.get(serviceCollection));
        }
    };
    public static final LazyLoadedCommandElement OPTIONAL_WEAK_DURATION = new LazyLoadedCommandElement(){

        @Override
        protected CommandElement create(INucleusServiceCollection serviceCollection) {
            return GenericArguments.optionalWeak((CommandElement)DURATION.get(serviceCollection));
        }
    };
    public static final CommandElement POSITION = GenericArguments.onlyOne((CommandElement)GenericArguments.vector3d((Text)Text.of((String)"x y z")));
    public static final CommandElement LOCATION = GenericArguments.onlyOne((CommandElement)GenericArguments.location((Text)Text.of((String)"location")));
    public static final CommandElement OPTIONAL_LOCATION = GenericArguments.optional((CommandElement)LOCATION);

    private NucleusParameters() {
    }

    public static abstract class LazyLoadedCommandElement {
        @Nullable
        private CommandElement load;

        public final CommandElement get(INucleusServiceCollection serviceCollection) {
            if (this.load == null) {
                this.load = this.create(serviceCollection);
            }
            return this.load;
        }

        protected abstract CommandElement create(INucleusServiceCollection var1);
    }

    public static class Keys {
        public static final String BOOL = "true|false";
        public static final String COMMAND = "command";
        public static final String DESCRIPTION = "description";
        public static final String DURATION = "duration";
        public static final String LOCATION = "location";
        public static final String LORE = "lore";
        public static final String MESSAGE = "message";
        public static final String PLAYER = "player";
        public static final String PLAYER_OR_CONSOLE = "player|-";
        public static final String REASON = "reason";
        public static final String SUBJECT = "subject";
        public static final String USER = "user";
        public static final String USER_UUID = "user uuid";
        public static final String WORLD = "world";
        public static final String XYZ = "x y z";

        private Keys() {
        }
    }
}

