/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.warp.commands.category;

import io.github.nucleuspowered.nucleus.api.module.warp.data.WarpCategory;
import io.github.nucleuspowered.nucleus.modules.warp.commands.category.CategoryCommand;
import io.github.nucleuspowered.nucleus.modules.warp.services.WarpService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.serializer.TextSerializers;

@Command(aliases={"setdescription"}, basePermission={"nucleus.warp.category.description.base"}, commandDescriptionKey="warp.category.setdescription", parentCommand=CategoryCommand.class)
public class CategoryDescriptionCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(WarpService.class).warpCategoryElement(), NucleusParameters.DESCRIPTION};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        WarpCategory category = context.requireOne("warp category", WarpCategory.class);
        String d = context.requireOne("description", String.class);
        context.getServiceCollection().getServiceUnchecked(WarpService.class).setWarpCategoryDescription(category.getId(), TextSerializers.FORMATTING_CODE.deserialize(d));
        context.sendMessage("command.warp.category.description.set", category.getId(), d);
        return context.successResult();
    }
}

