/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.serverlist.services;

import io.github.nucleuspowered.nucleus.modules.serverlist.ServerListKeys;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IGeneralDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;

public class ServerListService
implements ServiceBase {
    @Nullable
    private Optional<Text> messageCache = null;
    private Instant expiry = Instant.MAX;
    private final IStorageManager storageManager;

    @Inject
    public ServerListService(INucleusServiceCollection serviceCollection) {
        this.storageManager = serviceCollection.storageManager();
    }

    public void clearMessage() {
        IGeneralDataObject dataObject = (IGeneralDataObject)this.storageManager.getGeneralService().getOrNewOnThread();
        dataObject.remove(ServerListKeys.EXPIRY);
        dataObject.remove(ServerListKeys.LINE_ONE);
        dataObject.remove(ServerListKeys.LINE_TWO);
        this.expiry = Instant.MAX;
        this.messageCache = null;
    }

    public void updateLineOne(@Nullable String line1) {
        if (this.checkMessage()) {
            this.storageManager.getGeneralService().getOrNew().thenAccept(x -> x.set(ServerListKeys.LINE_ONE, line1));
        }
    }

    public void updateLineTwo(@Nullable String line2) {
        if (this.checkMessage()) {
            this.storageManager.getGeneralService().getOrNew().thenAccept(x -> x.set(ServerListKeys.LINE_TWO, line2));
        }
    }

    private boolean checkMessage() {
        if (this.messageCache == null) {
            this.constructMessage();
        }
        return this.messageCache.isPresent();
    }

    public void setMessage(@Nullable String line1, @Nullable String line2, @Nullable Instant expiry) {
        IGeneralDataObject dataObject = (IGeneralDataObject)this.storageManager.getGeneralService().getOrNewOnThread();
        dataObject.set(ServerListKeys.EXPIRY, expiry);
        dataObject.set(ServerListKeys.LINE_ONE, line1);
        dataObject.set(ServerListKeys.LINE_TWO, line2);
        this.expiry = expiry == null ? Instant.MAX : expiry;
        this.messageCache = null;
    }

    private void constructMessage() {
        IGeneralDataObject dataObject = (IGeneralDataObject)this.storageManager.getGeneralService().getOrNewOnThread();
        this.expiry = dataObject.get(ServerListKeys.EXPIRY).orElse(Instant.MAX);
        this.constructMessage(dataObject.get(ServerListKeys.LINE_ONE).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0)).orElse(null), dataObject.get(ServerListKeys.LINE_TWO).map(arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0)).orElse(null));
    }

    private void constructMessage(Text lineOne, Text lineTwo) {
        this.messageCache = lineOne != null || lineTwo != null ? Optional.of(Text.of((Object[])new Object[]{lineOne == null ? Text.EMPTY : lineOne, Text.NEW_LINE, lineTwo == null ? Text.EMPTY : lineTwo})) : Optional.empty();
    }

    public Optional<Text> getMessage() {
        if (this.expiry.isBefore(Instant.now())) {
            this.clearMessage();
        }
        if (this.messageCache == null) {
            this.constructMessage();
        }
        return this.messageCache;
    }

    public Optional<Instant> getExpiry() {
        if (this.expiry == Instant.MAX) {
            return Optional.empty();
        }
        return Optional.of(this.expiry);
    }
}

