/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.mute.services;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.mute.NucleusMuteService;
import io.github.nucleuspowered.nucleus.api.module.mute.data.Mute;
import io.github.nucleuspowered.nucleus.modules.mute.MuteKeys;
import io.github.nucleuspowered.nucleus.modules.mute.data.MuteData;
import io.github.nucleuspowered.nucleus.modules.mute.events.MuteEvent;
import io.github.nucleuspowered.nucleus.scaffold.service.ServiceBase;
import io.github.nucleuspowered.nucleus.scaffold.service.annotations.APIService;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.storage.dataobjects.modular.IUserDataObject;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IStorageManager;
import io.github.nucleuspowered.nucleus.util.CauseStackHelper;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.Identifiable;

@APIService(value=NucleusMuteService.class)
public class MuteHandler
implements ContextCalculator<Subject>,
NucleusMuteService,
ServiceBase {
    private final IMessageProviderService messageProviderService;
    private final IStorageManager storageManager;
    private final PluginContainer pluginContainer;
    private final Map<UUID, Boolean> muteContextCache = Maps.newHashMap();
    private final Context mutedContext = new Context("nucleus_muted", "true");
    private boolean globalMuteEnabled = false;
    private final List<UUID> voicedUsers = Lists.newArrayList();

    @Inject
    public MuteHandler(INucleusServiceCollection serviceCollection) {
        this.messageProviderService = serviceCollection.messageProvider();
        this.storageManager = serviceCollection.storageManager();
        this.pluginContainer = serviceCollection.pluginContainer();
    }

    public void onMute(Player user) {
        this.getPlayerMuteData((User)user).ifPresent(x -> this.onMute((MuteData)x, user));
    }

    public void onMute(MuteData md, Player user) {
        if (md.getRemainingTime().isPresent()) {
            this.messageProviderService.sendMessageTo((CommandSource)user, "mute.playernotify.time", this.messageProviderService.getTimeString(user.getLocale(), md.getRemainingTime().get().getSeconds()));
        } else {
            this.messageProviderService.sendMessageTo((CommandSource)user, "mute.playernotify.standard");
        }
    }

    @Override
    public boolean isMuted(User user) {
        return this.getPlayerMuteData(user).isPresent();
    }

    @Override
    public Optional<Mute> getPlayerMuteInfo(User user) {
        return this.getPlayerMuteData(user).map(x -> x);
    }

    public Optional<MuteData> getPlayerMuteData(User user) {
        Optional<MuteData> nu = this.storageManager.getOrCreateUserOnThread(user.getUniqueId()).get(MuteKeys.MUTE_DATA);
        this.muteContextCache.put(user.getUniqueId(), nu.isPresent());
        return nu;
    }

    @Override
    public boolean mutePlayer(User user, String reason, @Nullable Duration duration, Cause cause) {
        UUID first = cause.first(User.class).map(Identifiable::getUniqueId).orElse(Util.CONSOLE_FAKE_UUID);
        return this.mutePlayer(user, new MuteData(first, reason, duration), cause);
    }

    public boolean mutePlayer(User user, MuteData data) {
        return this.mutePlayer(user, data, CauseStackHelper.createCause(Util.getObjectFromUUID(data.getMuterInternal())));
    }

    public boolean mutePlayer(User user, MuteData data, Cause cause) {
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)data);
        Optional<IUserDataObject> nu = this.storageManager.getUserOnThread(user.getUniqueId());
        if (!nu.isPresent()) {
            return false;
        }
        Instant time = Instant.now();
        IUserDataObject u = nu.get();
        Duration d = data.getRemainingTime().orElse(null);
        if (user.isOnline() && data.getTimeFromNextLogin().isPresent() && !data.getEndTimestamp().isPresent()) {
            data.setEndtimestamp(time.plus(data.getTimeFromNextLogin().get()));
        }
        u.set(MuteKeys.MUTE_DATA, data);
        this.storageManager.saveUser(user.getUniqueId(), u);
        this.muteContextCache.put(user.getUniqueId(), true);
        Sponge.getEventManager().post((Event)new MuteEvent.Muted(cause, user, d, (Text)Text.of((String)data.getReason())));
        return true;
    }

    public boolean unmutePlayer(User user) {
        return this.unmutePlayer(user, CauseStackHelper.createCause(this.pluginContainer), true);
    }

    @Override
    public boolean unmutePlayer(User user, Cause cause) {
        return this.unmutePlayer(user, cause, false);
    }

    public boolean unmutePlayer(User user, Cause cause, boolean expired) {
        Optional<IUserDataObject> o;
        if (this.isMuted(user) && (o = this.storageManager.getUserOnThread(user.getUniqueId())).isPresent()) {
            IUserDataObject udo = o.get();
            udo.remove(MuteKeys.MUTE_DATA);
            this.storageManager.saveUser(user.getUniqueId(), udo);
            this.muteContextCache.put(user.getUniqueId(), false);
            Sponge.getEventManager().post((Event)new MuteEvent.Unmuted(cause, user, expired));
            user.getPlayer().ifPresent(x -> this.messageProviderService.sendMessageTo((CommandSource)x, "mute.elapsed"));
            return true;
        }
        return false;
    }

    public boolean isGlobalMuteEnabled() {
        return this.globalMuteEnabled;
    }

    public void setGlobalMuteEnabled(boolean globalMuteEnabled) {
        if (this.globalMuteEnabled != globalMuteEnabled) {
            this.voicedUsers.clear();
        }
        this.globalMuteEnabled = globalMuteEnabled;
    }

    public boolean isVoiced(UUID uuid) {
        return this.voicedUsers.contains(uuid);
    }

    public void addVoice(UUID uuid) {
        this.voicedUsers.add(uuid);
    }

    public void removeVoice(UUID uuid) {
        this.voicedUsers.remove(uuid);
    }

    public void accumulateContexts(Subject calculable, Set<Context> accumulator) {
        UUID u;
        if (calculable instanceof User && this.muteContextCache.computeIfAbsent(u = ((User)calculable).getUniqueId(), k -> this.isMuted((User)calculable)).booleanValue()) {
            accumulator.add(this.mutedContext);
        }
    }

    public boolean matches(Context context, Subject subject) {
        return context.getKey().equals("nucleus_muted") && subject instanceof User && this.muteContextCache.computeIfAbsent(((User)subject).getUniqueId(), k -> this.isMuted((User)subject)) != false;
    }

    public boolean isMutedCached(User x) {
        return this.muteContextCache.containsKey(x.getUniqueId());
    }
}

