/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.message.commands;

import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.NucleusKeysProvider;
import io.github.nucleuspowered.nucleus.services.impl.userprefs.UserPreferenceService;
import java.util.UUID;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"msgtoggle", "messagetoggle", "mtoggle"}, basePermission={"nucleus.msgtoggle.base"}, commandDescriptionKey="msgtoggle", associatedPermissions={"nucleus.msgtoggle.bypass"})
public class MsgToggleCommand
implements ICommandExecutor<Player> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        UserPreferenceService userPreferenceService = context.getServiceCollection().getServiceUnchecked(UserPreferenceService.class);
        UUID player = context.getIfPlayer().getUniqueId();
        boolean flip = context.getOne("true|false", Boolean.class).orElseGet(() -> userPreferenceService.getUnwrapped(player, NucleusKeysProvider.RECEIVING_MESSAGES));
        userPreferenceService.set(player, NucleusKeysProvider.RECEIVING_MESSAGES, Boolean.valueOf(flip));
        context.sendMessage("command.msgtoggle.success." + flip, new Object[0]);
        return context.successResult();
    }
}

