/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kit.commands;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.kit.data.Kit;
import io.github.nucleuspowered.nucleus.modules.kit.commands.KitCommand;
import io.github.nucleuspowered.nucleus.modules.kit.services.KitService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.time.Duration;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@Command(aliases={"info"}, async=true, basePermission={"nucleus.kit.info.base"}, commandDescriptionKey="kit.info", parentCommand=KitCommand.class)
public class KitInfoCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.getServiceUnchecked(KitService.class).createKitElement(false)};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        Kit kit = context.requireOne("kit", Kit.class);
        Util.getPaginationBuilder(context.getCommandSource()).title(context.getMessage("command.kit.info.title", kit.getName())).contents(new Text[]{this.addViewHover(context, kit), this.addCommandHover(context, kit), context.getMessage("command.kit.info.sep", new Object[0]), context.getMessage("command.kit.info.firstjoin", this.yesno(context, kit.isFirstJoinKit())), context.getMessage("command.kit.info.cost", String.valueOf(kit.getCost())), context.getMessage("command.kit.info.cooldown", kit.getCooldown().map(x -> Text.of((String)context.getTimeString((Duration)x))).orElseGet(() -> context.getMessage("standard.nocooldown", new Object[0]))), context.getMessage("command.kit.info.onetime", this.yesno(context, kit.isOneTime())), context.getMessage("command.kit.info.autoredeem", this.yesno(context, kit.isAutoRedeem())), context.getMessage("command.kit.info.hidden", this.yesno(context, kit.isHiddenFromList())), context.getMessage("command.kit.info.displayredeem", this.yesno(context, kit.isDisplayMessageOnRedeem())), context.getMessage("command.kit.info.ignoresperm", this.yesno(context, kit.ignoresPermission()))}).sendTo((MessageReceiver)context.getCommandSource());
        return context.successResult();
    }

    private Text addViewHover(ICommandContext<? extends CommandSource> context, Kit kit) {
        return context.getMessage("command.kit.info.itemcount", String.valueOf(kit.getStacks().size())).toBuilder().onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.kit.info.hover.itemcount", kit.getName()))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:kit view " + kit.getName()))).build();
    }

    private Text addCommandHover(ICommandContext<? extends CommandSource> context, Kit kit) {
        return context.getMessage("command.kit.info.commandcount", String.valueOf(kit.getCommands().size())).toBuilder().onHover((HoverAction)TextActions.showText((Text)context.getMessage("command.kit.info.hover.commandcount", kit.getName()))).onClick((ClickAction)TextActions.runCommand((String)("/nucleus:kit command " + kit.getName()))).build();
    }

    private String yesno(ICommandContext<? extends CommandSource> context, boolean yesno) {
        return context.getMessageString("standard.yesno." + yesno, new Object[0]);
    }
}

