/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.ignore.listeners;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.api.module.mail.event.NucleusMailEvent;
import io.github.nucleuspowered.nucleus.api.module.message.event.NucleusMessageEvent;
import io.github.nucleuspowered.nucleus.modules.ignore.services.IgnoreService;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IChatMessageFormatterService;
import io.github.nucleuspowered.nucleus.services.interfaces.IPermissionService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.inject.Inject;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.channel.MutableMessageChannel;

public class IgnoreListener
implements ListenerBase {
    private final IgnoreService service;
    private final IPermissionService permissionService;
    private final IChatMessageFormatterService chatMessageFormatterService;

    @Inject
    public IgnoreListener(INucleusServiceCollection serviceCollection) {
        this.service = serviceCollection.getServiceUnchecked(IgnoreService.class);
        this.permissionService = serviceCollection.permissionService();
        this.chatMessageFormatterService = serviceCollection.chatMessageFormatter();
    }

    @Listener(order=Order.LAST)
    public void onChat(MessageChannelEvent.Chat event) {
        Util.onPlayerSimulatedOrPlayer(event, this::onChat);
    }

    private void onChat(MessageChannelEvent.Chat event, Player player) {
        if (!this.chatMessageFormatterService.getNucleusChannel(player.getUniqueId()).map(IChatMessageFormatterService.Channel::ignoreIgnoreList).orElse(false).booleanValue()) {
            this.checkCancels(event.getChannel().orElseGet(() -> ((MessageChannelEvent.Chat)event).getOriginalChannel()).getMembers(), player).ifPresent(x -> {
                MutableMessageChannel mmc = event.getChannel().orElseGet(() -> ((MessageChannelEvent.Chat)event).getOriginalChannel()).asMutable();
                x.forEach(arg_0 -> ((MutableMessageChannel)mmc).removeMember(arg_0));
                event.setChannel((MessageChannel)mmc);
            });
        }
    }

    @Listener(order=Order.FIRST)
    public void onMessage(NucleusMessageEvent event, @Root Player player) {
        if (event.getRecipient() instanceof User) {
            try {
                event.setCancelled(this.service.isIgnored(((User)event.getRecipient()).getUniqueId(), player.getUniqueId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Listener(order=Order.FIRST)
    public void onMail(NucleusMailEvent event, @Root Player player) {
        try {
            event.setCancelled(this.service.isIgnored(event.getRecipient().getUniqueId(), player.getUniqueId()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Optional<Collection<MessageReceiver>> checkCancels(Collection<MessageReceiver> collection, Player player) {
        if (this.permissionService.hasPermission((Subject)player, "nucleus.ignore.exempt.chat")) {
            return Optional.empty();
        }
        ArrayList list = Lists.newArrayList(collection);
        list.removeIf(x -> {
            try {
                if (!(x instanceof Player)) {
                    return true;
                }
                if (x.equals(player)) {
                    return true;
                }
                return !this.service.isIgnored(((Player)x).getUniqueId(), player.getUniqueId());
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(list);
    }
}

