/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.home.commands;

import io.github.nucleuspowered.nucleus.api.module.home.data.Home;
import io.github.nucleuspowered.nucleus.api.teleport.data.TeleportResult;
import io.github.nucleuspowered.nucleus.modules.home.config.HomeConfig;
import io.github.nucleuspowered.nucleus.modules.home.events.UseHomeEvent;
import io.github.nucleuspowered.nucleus.modules.home.parameters.HomeArgument;
import io.github.nucleuspowered.nucleus.modules.home.services.HomeService;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@EssentialsEquivalent(value={"home", "homes"}, notes="'/homes' will list homes, '/home' will teleport like Essentials did.")
@Command(aliases={"home"}, basePermission={"nucleus.home.base"}, commandDescriptionKey="home", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.home.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.home.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.home.exempt.cost")}, associatedPermissions={"nucleus.home.exempt.samedimension"})
@NonnullByDefault
public class HomeCommand
implements ICommandExecutor<Player>,
IReloadableService.Reloadable {
    private final String home = "home";
    private boolean isSafeTeleport = true;
    private boolean isPreventOverhang = true;
    private boolean isOnlySameDimension = false;

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.optional((CommandElement)new HomeArgument((Text)Text.of((String)this.home), serviceCollection.getServiceUnchecked(HomeService.class), serviceCollection.messageProvider())))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends Player> context) throws CommandException {
        Home wl;
        HomeService homeService = context.getServiceCollection().getServiceUnchecked(HomeService.class);
        Player player = context.getIfPlayer();
        int max = homeService.getMaximumHomes((User)player);
        int current = homeService.getHomeCount((User)player);
        if (this.isPreventOverhang && max < current) {
            return context.errorResult("command.home.overhang", max, current);
        }
        Optional<Home> owl = context.getOne(this.home, Home.class);
        if (owl.isPresent()) {
            wl = owl.get();
        } else {
            Optional<Home> home = homeService.getHome((User)player, "home");
            if (!home.isPresent()) {
                return context.errorResult("args.home.nohome", "home");
            }
            wl = home.get();
        }
        Sponge.getServer().loadWorld(wl.getWorldProperties().orElseThrow(() -> context.createException("command.home.invalid", wl.getName())));
        Location<World> targetLocation = wl.getLocation().orElseThrow(() -> context.createException("command.home.invalid", wl.getName()));
        if (this.isOnlySameDimension && !((World)targetLocation.getExtent()).getUniqueId().equals(((World)player.getLocation().getExtent()).getUniqueId()) && !context.testPermission("nucleus.home.exempt.samedimension")) {
            return context.errorResult("command.home.invalid", wl.getName());
        }
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause((Object)player);
            UseHomeEvent event = new UseHomeEvent(frame.getCurrentCause(), (User)player, wl);
            if (Sponge.getEventManager().post((Event)event)) {
                ICommandResult iCommandResult = event.getCancelMessage().map(x -> context.errorResultLiteral(Text.of((Object[])new Object[]{x}))).orElseGet(() -> context.errorResult("nucleus.eventcancelled", new Object[0]));
                return iCommandResult;
            }
        }
        TeleportResult result = homeService.warpToHome(player, wl, this.isSafeTeleport);
        if (result.isSuccessful()) {
            if (!wl.getName().equalsIgnoreCase("home")) {
                context.sendMessage("command.home.success", wl.getName());
            } else {
                context.sendMessage("command.home.successdefault", new Object[0]);
            }
            return context.successResult();
        }
        return context.errorResult("command.home.fail", wl.getName());
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        HomeConfig hc = serviceCollection.moduleDataProvider().getModuleConfig(HomeConfig.class);
        this.isSafeTeleport = hc.isSafeTeleport();
        this.isPreventOverhang = hc.isPreventHomeCountOverhang();
        this.isOnlySameDimension = hc.isOnlySameDimension();
    }
}

