/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.fly.commands;

import io.github.nucleuspowered.nucleus.modules.fly.FlyKeys;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@EssentialsEquivalent(value={"fly"})
@NonnullByDefault
@Command(aliases={"fly"}, basePermission={"nucleus.fly.base"}, commandDescriptionKey="fly", modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.fly.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.fly.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.fly.exempt.cost")}, associatedPermissions={"nucleus.fly.others"})
public class FlyCommand
implements ICommandExecutor<CommandSource> {
    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{serviceCollection.commandElementSupplier().createOtherUserPermissionElement(true, "nucleus.fly.others"), NucleusParameters.OPTIONAL_ONE_TRUE_FALSE};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) throws CommandException {
        boolean fly;
        Player player = context.getPlayerFromArgs();
        if (!this.setFlying(player, fly = context.getOne("true|false", Boolean.class).orElse(player.get(Keys.CAN_FLY).orElse(false) == false).booleanValue())) {
            return context.errorResult("command.fly.error", new Object[0]);
        }
        context.getServiceCollection().storageManager().getOrCreateUser(player.getUniqueId()).thenAccept(x -> x.set(FlyKeys.FLY_TOGGLE, fly));
        if (!context.is(player)) {
            context.sendMessage(fly ? "command.fly.player.on" : "command.fly.player.off", player.getName());
        }
        context.sendMessageTo((MessageReceiver)player, fly ? "command.fly.on" : "command.fly.off", new Object[0]);
        return context.successResult();
    }

    private boolean setFlying(Player pl, boolean fly) {
        return (fly || pl.offer(Keys.IS_FLYING, (Object)false).isSuccessful()) && pl.offer(Keys.CAN_FLY, (Object)fly).isSuccessful();
    }
}

