/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.environment.commands;

import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.environment.commands.TimeCommand;
import io.github.nucleuspowered.nucleus.modules.environment.parameter.WorldTimeArgument;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandContext;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandExecutor;
import io.github.nucleuspowered.nucleus.scaffold.command.ICommandResult;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.Command;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.CommandModifier;
import io.github.nucleuspowered.nucleus.scaffold.command.annotation.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.function.LongFunction;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.storage.WorldProperties;

@EssentialsEquivalent(value={"time", "day", "night"}, isExact=false, notes="A time MUST be specified.")
@NonnullByDefault
@Command(aliases={"set", "#settime", "#timeset"}, basePermission={"nucleus.time.set.base"}, commandDescriptionKey="time.set", parentCommand=TimeCommand.class, modifiers={@CommandModifier(value="nucleus:has_cooldown", exemptPermission="nucleus.time.set.exempt.cooldown"), @CommandModifier(value="nucleus:has_warmup", exemptPermission="nucleus.time.set.exempt.warmup"), @CommandModifier(value="nucleus:has_cost", exemptPermission="nucleus.time.set.exempt.cost")})
public class SetTimeCommand
implements ICommandExecutor<CommandSource> {
    private final String time = "time";
    private final String world = "world";

    @Override
    public CommandElement[] parameters(INucleusServiceCollection serviceCollection) {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)GenericArguments.onlyOne((CommandElement)GenericArguments.world((Text)Text.of((String)this.world)))), GenericArguments.onlyOne((CommandElement)new WorldTimeArgument((Text)Text.of((String)this.time), serviceCollection))};
    }

    @Override
    public ICommandResult execute(ICommandContext<? extends CommandSource> context) {
        WorldProperties pr = context.getWorldPropertiesOrFromSelf(this.world).orElseGet(() -> (WorldProperties)Sponge.getServer().getDefaultWorld().get());
        LongFunction<Long> tick = context.requireOne(this.time, new TypeToken<LongFunction<Long>>(){});
        long time = tick.apply(pr.getWorldTime());
        pr.setWorldTime(time);
        context.sendMessage("command.settime.done2", pr.getWorldName(), Util.getTimeFromTicks(context.getServiceCollection().messageProvider(), time));
        return context.successResult();
    }
}

