/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.commandlogger.listeners;

import com.google.common.collect.ImmutableSet;
import io.github.nucleuspowered.nucleus.modules.commandlogger.config.CommandLoggerConfig;
import io.github.nucleuspowered.nucleus.modules.commandlogger.services.CommandLoggerHandler;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IMessageProviderService;
import io.github.nucleuspowered.nucleus.services.interfaces.IReloadableService;
import io.github.nucleuspowered.nucleus.util.CommandNameCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.source.CommandBlockSource;
import org.spongepowered.api.command.source.ConsoleSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.command.SendCommandEvent;
import org.spongepowered.api.event.filter.cause.First;
import org.spongepowered.api.event.game.state.GameStoppedServerEvent;
import org.spongepowered.api.plugin.PluginContainer;

public class CommandLoggingListener
implements IReloadableService.Reloadable,
ListenerBase {
    private final CommandLoggerHandler handler;
    private final IMessageProviderService messageProvider;
    private CommandLoggerConfig c;
    private Set<String> commandsToFilter = new HashSet<String>();
    private Logger logger;

    @Inject
    public CommandLoggingListener(INucleusServiceCollection serviceCollection) {
        this.handler = serviceCollection.getServiceUnchecked(CommandLoggerHandler.class);
        this.c = serviceCollection.moduleDataProvider().getModuleConfig(CommandLoggerConfig.class);
        this.messageProvider = serviceCollection.messageProvider();
        this.logger = serviceCollection.logger();
    }

    @Listener(order=Order.LAST)
    public void onCommand(SendCommandEvent event, @First CommandSource source) {
        boolean accept = source instanceof Player ? this.c.getLoggerTarget().isLogPlayer() : (source instanceof CommandBlockSource ? this.c.getLoggerTarget().isLogCommandBlock() : (source instanceof ConsoleSource ? this.c.getLoggerTarget().isLogConsole() : this.c.getLoggerTarget().isLogOther()));
        if (!accept) {
            return;
        }
        String command = event.getCommand().toLowerCase();
        Set<String> commands = CommandNameCache.INSTANCE.getFromCommandAndSource(command, source);
        commands.retainAll(this.commandsToFilter);
        if (this.c.isWhitelist() == !commands.isEmpty()) {
            String cause;
            if (this.c.isCauseEnhanced()) {
                List l = event.getCause().all().stream().filter(x -> (x instanceof PluginContainer || x instanceof CommandSource) && x != source).map(x -> {
                    if (x instanceof CommandSource) {
                        return ((CommandSource)x).getName();
                    }
                    return "(plugin) " + ((PluginContainer)x).getName();
                }).collect(Collectors.toList());
                if (l.isEmpty()) {
                    cause = source.getName();
                } else {
                    ArrayList stack = new ArrayList(l);
                    Collections.reverse(stack);
                    cause = String.format("[ %s -> ] %s", String.join((CharSequence)" -> ", stack), source.getName());
                }
            } else {
                cause = source.getName();
            }
            String message = this.messageProvider.getMessageString("commandlog.message", cause, event.getCommand(), event.getArguments());
            this.logger.info(message);
            this.handler.queueEntry(message);
        }
    }

    @Listener
    public void onShutdown(GameStoppedServerEvent event) {
        try {
            this.handler.onServerShutdown();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onReload(INucleusServiceCollection serviceCollection) {
        this.c = serviceCollection.moduleDataProvider().getModuleConfig(CommandLoggerConfig.class);
        this.commandsToFilter = (Set)this.c.getCommandsToFilter().stream().map(String::toLowerCase).collect(ImmutableSet.toImmutableSet());
    }
}

