/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.chat.listeners;

import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.modules.chat.config.ChatConfig;
import io.github.nucleuspowered.nucleus.scaffold.listener.ListenerBase;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.message.MessageChannelEvent;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.serializer.TextSerializers;

public class BodyFixChatListener
implements ListenerBase.Conditional,
ListenerBase {
    private static final Pattern bodyPattern = Pattern.compile("^\\s*<[a-zA-Z0-9_]+>\\s*");
    private static final Pattern colorCodeAdjustment = Pattern.compile("^((&[0-9a-fklmno])+)\\s+");

    @Listener(order=Order.LATE)
    public void onChat(MessageChannelEvent.Chat event) {
        Util.onPlayerSimulatedOrPlayer(event, this::onChat);
    }

    private void onChat(MessageChannelEvent.Chat event, Player player) {
        if (bodyPattern.matcher(event.getFormatter().getBody().toText().toPlain()).find()) {
            String m = TextSerializers.FORMATTING_CODE.serialize(event.getFormatter().getBody().toText());
            Matcher matcher = colorCodeAdjustment.matcher(m = m.replaceFirst("<" + player.getName() + ">", "").trim());
            if (matcher.find()) {
                m = m.replaceFirst(matcher.group(), matcher.group(1));
            }
            event.getFormatter().setBody((TextRepresentable)TextSerializers.FORMATTING_CODE.deserialize(m));
        }
    }

    @Override
    public boolean shouldEnable(INucleusServiceCollection serviceCollection) {
        return serviceCollection.moduleDataProvider().getModuleConfig(ChatConfig.class).isCheckBody();
    }
}

