/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import io.github.nucleuspowered.nucleus.guice.ConfigDirectory;
import io.github.nucleuspowered.nucleus.guice.DataDirectory;
import io.github.nucleuspowered.nucleus.services.INucleusServiceCollection;
import io.github.nucleuspowered.nucleus.services.interfaces.IModuleDataProvider;
import io.github.nucleuspowered.relocate.uk.co.drnaylor.quickstart.holders.DiscoveryModuleHolder;
import java.nio.file.Path;
import java.util.function.Supplier;

public class NucleusInjectorModule
extends AbstractModule {
    private final Supplier<INucleusServiceCollection> serviceCollection;
    private final Supplier<Path> dataDirectory;
    private final Path configDirectory;
    private final IModuleDataProvider moduleDataProvider;
    private final Supplier<DiscoveryModuleHolder<?, ?>> discoveryModuleHolderSupplier;

    public NucleusInjectorModule(Supplier<INucleusServiceCollection> serviceCollection, Supplier<Path> dataDirectory, Supplier<DiscoveryModuleHolder<?, ?>> discoveryModuleHolderSupplier, Path configDirectory, IModuleDataProvider moduleDataProvider) {
        this.dataDirectory = dataDirectory;
        this.configDirectory = configDirectory;
        this.moduleDataProvider = moduleDataProvider;
        this.serviceCollection = serviceCollection;
        this.discoveryModuleHolderSupplier = discoveryModuleHolderSupplier;
    }

    protected void configure() {
        this.bind((TypeLiteral)new TypeLiteral<Supplier<Path>>(){}).annotatedWith(DataDirectory.class).toInstance(this.dataDirectory);
        this.bind(Path.class).annotatedWith(ConfigDirectory.class).toInstance((Object)this.configDirectory);
        this.bind(IModuleDataProvider.class).toInstance((Object)this.moduleDataProvider);
    }

    @Provides
    private INucleusServiceCollection provideServiceCollection() {
        return this.serviceCollection.get();
    }

    @Provides
    private Supplier<DiscoveryModuleHolder<?, ?>> getModuleHolder() {
        return this.discoveryModuleHolderSupplier;
    }
}

