/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.libnine.util.world;

import io.github.phantamanta44.libnine.util.data.ByteUtils;
import io.github.phantamanta44.libnine.util.data.ISerializable;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class DirectionToggle
implements Iterable<EnumFacing>,
ISerializable {
    private final boolean[] dirs = new boolean[EnumFacing.field_82609_l.length];

    public boolean get(EnumFacing dir) {
        return this.dirs[dir.ordinal()];
    }

    public void set(EnumFacing dir, boolean value) {
        this.dirs[dir.ordinal()] = value;
    }

    public boolean toggle(EnumFacing dir) {
        boolean bl = !this.dirs[dir.ordinal()];
        this.dirs[dir.ordinal()] = bl;
        return bl;
    }

    public void clear() {
        Arrays.fill(this.dirs, false);
    }

    @Override
    public Iterator<EnumFacing> iterator() {
        return Arrays.stream(EnumFacing.field_82609_l).filter(d -> this.dirs[d.ordinal()]).iterator();
    }

    @Override
    public void serBytes(ByteUtils.Writer data) {
        byte mask = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.dirs[dir.ordinal()]) continue;
            mask = (byte)(mask | 1 << dir.ordinal());
        }
        data.writeByte(mask);
    }

    @Override
    public void deserBytes(ByteUtils.Reader data) {
        byte mask = data.readByte();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.dirs[dir.ordinal()] = (mask & 1 << dir.ordinal()) != 0;
        }
    }

    @Override
    public void serNBT(NBTTagCompound tag) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            tag.func_74757_a(dir.func_176610_l(), this.dirs[dir.ordinal()]);
        }
    }

    @Override
    public void deserNBT(NBTTagCompound tag) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.dirs[dir.ordinal()] = tag.func_74767_n(dir.func_176610_l());
        }
    }
}

