/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.shaper;

import java.util.List;
import mcjty.lib.tileentity.GenericEnergyReceiverTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Counter;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftools.blocks.builder.BuilderSetup;
import mcjty.rftools.blocks.shaper.ScannerConfiguration;
import mcjty.rftools.blocks.shaper.ScannerTileEntity;
import mcjty.rftools.shapes.BeaconType;
import mcjty.rftools.shapes.ScanDataManager;
import mcjty.rftools.shapes.ScanExtraData;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LocatorTileEntity
extends GenericEnergyReceiverTileEntity
implements ITickable {
    public static final String CMD_SETTINGS = "locator.setSettings";
    public static final Key<String> PARAM_HOSTILE_TYPE = new Key("hostile", Type.STRING);
    public static final Key<String> PARAM_PASSIVE_TYPE = new Key("passive", Type.STRING);
    public static final Key<String> PARAM_PLAYER_TYPE = new Key("player", Type.STRING);
    public static final Key<String> PARAM_ENERGY_TYPE = new Key("energy", Type.STRING);
    public static final Key<Boolean> PARAM_HOSTILE_BEACON = new Key("hostileBeacon", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_PASSIVE_BEACON = new Key("passiveBeacon", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_PLAYER_BEACON = new Key("playerBeacon", Type.BOOLEAN);
    public static final Key<Boolean> PARAM_ENERGY_BEACON = new Key("energyBeacon", Type.BOOLEAN);
    public static final Key<String> PARAM_FILTER = new Key("filter", Type.STRING);
    public static final Key<Integer> PARAM_MIN_ENERGY = new Key("minEnergy", Type.INTEGER);
    public static final Key<Integer> PARAM_MAX_ENERGY = new Key("maxEnergy", Type.INTEGER);
    private int counter = 0;
    private BeaconType hostileType = BeaconType.BEACON_OFF;
    private boolean hostileBeacon = false;
    private BeaconType passiveType = BeaconType.BEACON_YELLOW;
    private boolean passiveBeacon = false;
    private BeaconType playerType = BeaconType.BEACON_OFF;
    private boolean playerBeacon = false;
    private BeaconType energyType = BeaconType.BEACON_OFF;
    private boolean energyBeacon = false;
    private String filter = "";
    private Integer minEnergy = null;
    private Integer maxEnergy = null;

    public LocatorTileEntity() {
        super((long)ScannerConfiguration.LOCATOR_MAXENERGY.get(), (long)ScannerConfiguration.LOCATOR_RECEIVEPERTICK.get());
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K && this.isMachineEnabled()) {
            --this.counter;
            this.markDirtyQuick();
            if (this.counter <= 0) {
                this.counter = ScannerConfiguration.ticksPerLocatorScan.get();
                ScannerTileEntity scanner = this.getScanner();
                if (scanner == null || scanner.getDataDim() == null) {
                    return;
                }
                int energy = this.getEnergyPerScan(scanner);
                if (this.getStoredPower() < (long)energy) {
                    return;
                }
                BlockPos dim = scanner.getDataDim();
                BlockPos start = scanner.getFirstCorner();
                if (start == null) {
                    return;
                }
                World scanWorld = scanner.getScanWorld(scanner.getScanDimension());
                this.consumeEnergy(energy);
                AxisAlignedBB bb = new AxisAlignedBB(start, start.func_177971_a((Vec3i)dim));
                List entities = scanWorld.func_72872_a(EntityLivingBase.class, bb);
                int scanId = scanner.getScanId();
                ScanExtraData extraData = ScanDataManager.getScans().getExtraData(scanId);
                extraData.touch();
                extraData.clear();
                BlockPos center = scanner.getScanCenter();
                this.findEntityBeacons(entities, extraData, center);
                this.findEnergyBeacons(scanner, extraData, dim, start, center, scanWorld);
            }
        }
    }

    private void findEnergyBeacons(ScannerTileEntity scanner, ScanExtraData extraData, BlockPos dim, BlockPos start, BlockPos center, World scanWorld) {
        int dz;
        int dx;
        int chunks;
        if (this.energyType != BeaconType.BEACON_OFF && (chunks = (dx = (dim.func_177958_n() + 15) / 16) * (dz = (dim.func_177952_p() + 15) / 16)) <= ScannerConfiguration.locatorMaxEnergyChunks.get()) {
            BlockPos end = scanner.getLastCorner();
            int minChunkX = start.func_177958_n() >> 4;
            int minChunkZ = start.func_177952_p() >> 4;
            int maxChunkX = end.func_177958_n() >> 4;
            int maxChunkZ = end.func_177952_p() >> 4;
            BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
            for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int rx = (cx << 4) + x;
                            int rz = (cz << 4) + z;
                            if (rx < start.func_177958_n() || rx >= end.func_177958_n() || rz < start.func_177952_p() || rz >= end.func_177952_p()) continue;
                            for (int ry = start.func_177956_o(); ry < end.func_177956_o(); ++ry) {
                                int pct;
                                mpos.func_181079_c(rx, ry, rz);
                                TileEntity tileEntity = scanWorld.func_175625_s((BlockPos)mpos);
                                if (!EnergyTools.isEnergyTE((TileEntity)tileEntity, null)) continue;
                                BlockPos pos = mpos.func_177973_b((Vec3i)center);
                                EnergyTools.EnergyLevel el = EnergyTools.getEnergyLevelMulti((TileEntity)tileEntity, null);
                                long max = el.getMaxEnergy();
                                long e = el.getEnergy();
                                int n = pct = max > 0L ? (int)(e * 100L / max) : 0;
                                if (this.minEnergy != null && pct < this.minEnergy) {
                                    extraData.addBeacon(pos, this.energyType, this.energyBeacon);
                                    continue;
                                }
                                if (this.maxEnergy == null || pct <= this.maxEnergy) continue;
                                extraData.addBeacon(pos, this.energyType, this.energyBeacon);
                            }
                        }
                    }
                }
            }
        }
    }

    private void findEntityBeacons(List<Entity> entities, ScanExtraData extraData, BlockPos center) {
        Counter counter = new Counter();
        boolean dofilter = this.filter != null && !this.filter.trim().isEmpty();
        String filt = "";
        if (dofilter) {
            filt = this.filter.toLowerCase();
        }
        for (Entity entity : entities) {
            BlockPos pos = entity.func_180425_c().func_177973_b((Vec3i)center);
            if ((Integer)counter.getOrDefault((Object)pos, (Object)0) >= ScannerConfiguration.locatorEntitySafety.get() || dofilter && !this.checkFilter(filt, entity)) continue;
            if (entity instanceof EntityAnimal) {
                if (this.passiveType == BeaconType.BEACON_OFF) continue;
                extraData.addBeacon(pos, this.passiveType, this.passiveBeacon);
                counter.increment((Object)pos);
                continue;
            }
            if (entity instanceof EntityPlayer) {
                if (this.playerType == BeaconType.BEACON_OFF) continue;
                extraData.addBeacon(pos, this.playerType, this.playerBeacon);
                counter.increment((Object)pos);
                continue;
            }
            if (this.hostileType == BeaconType.BEACON_OFF) continue;
            extraData.addBeacon(pos, this.hostileType, this.hostileBeacon);
            counter.increment((Object)pos);
        }
    }

    private boolean checkFilter(String filt, Entity entity) {
        String nameTag;
        String name = entity.func_70005_c_().toLowerCase();
        if (name.contains(filt)) {
            return true;
        }
        return entity.func_145818_k_() && (nameTag = entity.func_95999_t().toLowerCase()).contains(filt);
    }

    public int getEnergyPerScan() {
        ScannerTileEntity scanner = this.getScanner();
        if (scanner == null) {
            return Integer.MAX_VALUE;
        }
        return this.getEnergyPerScan(scanner);
    }

    public int getEnergyPerScan(ScannerTileEntity scanner) {
        BlockPos dim = scanner.getDataDim();
        if (dim == null) {
            return Integer.MAX_VALUE;
        }
        int dx = (dim.func_177958_n() + 15) / 16;
        int dy = (dim.func_177956_o() + 15) / 16;
        int dz = (dim.func_177952_p() + 15) / 16;
        int subchunks = dx * dy * dz;
        int chunks = dx * dz;
        int energy = ScannerConfiguration.LOCATOR_PERSCAN_BASE.get();
        energy += (int)((double)energy + (double)subchunks * ScannerConfiguration.LOCATOR_PERSCAN_CHUNK.get());
        if (this.hostileType != BeaconType.BEACON_OFF) {
            energy += (int)((double)energy + (double)subchunks * ScannerConfiguration.LOCATOR_PERSCAN_HOSTILE.get());
        }
        if (this.passiveType != BeaconType.BEACON_OFF) {
            energy += (int)((double)energy + (double)subchunks * ScannerConfiguration.LOCATOR_PERSCAN_PASSIVE.get());
        }
        if (this.playerType != BeaconType.BEACON_OFF) {
            energy += (int)((double)energy + (double)subchunks * ScannerConfiguration.LOCATOR_PERSCAN_PLAYER.get());
        }
        if (this.energyType != BeaconType.BEACON_OFF && chunks <= ScannerConfiguration.locatorMaxEnergyChunks.get()) {
            energy += (int)((double)energy + (double)subchunks * ScannerConfiguration.LOCATOR_PERSCAN_ENERGY.get());
        }
        if (this.filter == null || !this.filter.trim().isEmpty()) {
            energy += (int)((double)energy + (double)subchunks * ScannerConfiguration.LOCATOR_FILTER_COST.get());
        }
        return energy;
    }

    private ScannerTileEntity getScanner() {
        TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
        if (te instanceof ScannerTileEntity) {
            return (ScannerTileEntity)te;
        }
        return null;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public String getFilter() {
        return this.filter;
    }

    public Integer getMinEnergy() {
        return this.minEnergy;
    }

    public Integer getMaxEnergy() {
        return this.maxEnergy;
    }

    public BeaconType getHostileType() {
        return this.hostileType;
    }

    public boolean isHostileBeacon() {
        return this.hostileBeacon;
    }

    public BeaconType getPassiveType() {
        return this.passiveType;
    }

    public boolean isPassiveBeacon() {
        return this.passiveBeacon;
    }

    public BeaconType getPlayerType() {
        return this.playerType;
    }

    public boolean isPlayerBeacon() {
        return this.playerBeacon;
    }

    public BeaconType getEnergyType() {
        return this.energyType;
    }

    public boolean isEnergyBeacon() {
        return this.energyBeacon;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.counter = tagCompound.func_74762_e("counter");
        this.hostileType = BeaconType.getTypeByCode(tagCompound.func_74779_i("hostile"));
        this.passiveType = BeaconType.getTypeByCode(tagCompound.func_74779_i("passive"));
        this.playerType = BeaconType.getTypeByCode(tagCompound.func_74779_i("player"));
        this.energyType = BeaconType.getTypeByCode(tagCompound.func_74779_i("energylow"));
        this.hostileBeacon = tagCompound.func_74767_n("hostileBeacon");
        this.passiveBeacon = tagCompound.func_74767_n("passiveBeacon");
        this.playerBeacon = tagCompound.func_74767_n("playerBeacon");
        this.energyBeacon = tagCompound.func_74767_n("energyBeacon");
        this.filter = tagCompound.func_74779_i("filter");
        this.minEnergy = tagCompound.func_74764_b("minEnergy") ? Integer.valueOf(tagCompound.func_74762_e("minEnergy")) : null;
        this.maxEnergy = tagCompound.func_74764_b("maxEnergy") ? Integer.valueOf(tagCompound.func_74762_e("maxEnergy")) : null;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("counter", this.counter);
        tagCompound.func_74778_a("hostile", this.hostileType.getCode());
        tagCompound.func_74778_a("passive", this.passiveType.getCode());
        tagCompound.func_74778_a("player", this.playerType.getCode());
        tagCompound.func_74778_a("energylow", this.energyType.getCode());
        tagCompound.func_74757_a("hostileBeacon", this.hostileBeacon);
        tagCompound.func_74757_a("passiveBeacon", this.passiveBeacon);
        tagCompound.func_74757_a("playerBeacon", this.playerBeacon);
        tagCompound.func_74757_a("energyBeacon", this.energyBeacon);
        tagCompound.func_74778_a("filter", this.filter);
        if (this.minEnergy != null) {
            tagCompound.func_74768_a("minEnergy", this.minEnergy.intValue());
        }
        if (this.maxEnergy != null) {
            tagCompound.func_74768_a("maxEnergy", this.maxEnergy.intValue());
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            this.hostileType = BeaconType.getTypeByCode((String)params.get(PARAM_HOSTILE_TYPE));
            this.passiveType = BeaconType.getTypeByCode((String)params.get(PARAM_PASSIVE_TYPE));
            this.playerType = BeaconType.getTypeByCode((String)params.get(PARAM_PLAYER_TYPE));
            this.energyType = BeaconType.getTypeByCode((String)params.get(PARAM_ENERGY_TYPE));
            this.hostileBeacon = (Boolean)params.get(PARAM_HOSTILE_BEACON);
            this.passiveBeacon = (Boolean)params.get(PARAM_PASSIVE_BEACON);
            this.playerBeacon = (Boolean)params.get(PARAM_PLAYER_BEACON);
            this.energyBeacon = (Boolean)params.get(PARAM_ENERGY_BEACON);
            this.filter = (String)params.get(PARAM_FILTER);
            this.minEnergy = params.get(PARAM_MIN_ENERGY) != null ? (Integer)params.get(PARAM_MIN_ENERGY) : null;
            this.maxEnergy = params.get(PARAM_MAX_ENERGY) != null ? (Integer)params.get(PARAM_MAX_ENERGY) : null;
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    @Optional.Method(modid="theoneprobe")
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        if (world.func_180495_p(data.getPos().func_177977_b()).func_177230_c() != BuilderSetup.scannerBlock) {
            probeInfo.text(TextStyleClass.ERROR + "Error! Needs a scanner below!");
        } else {
            probeInfo.text(TextStyleClass.INFO + "Scanner detected");
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="waila")
    public void addWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.addWailaBody(itemStack, currenttip, accessor, config);
        if (accessor.getWorld().func_180495_p(accessor.getPosition().func_177977_b()).func_177230_c() != BuilderSetup.scannerBlock) {
            currenttip.add(TextFormatting.RED.toString() + TextFormatting.BOLD + "Error! Needs a scanner below!");
        } else {
            currenttip.add(TextFormatting.WHITE + "Scanner detected");
        }
    }
}

