/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg;

import gcewing.sg.BaseMod;
import gcewing.sg.BaseSubsystem;
import gcewing.sg.Trans3;
import gcewing.sg.Vector3;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;

public class BaseModClient<MOD extends BaseMod<? extends BaseModClient>>
implements IGuiHandler {
    MOD base;
    boolean debugSound = false;
    Map<Integer, Class<? extends GuiScreen>> screenClasses = new HashMap<Integer, Class<? extends GuiScreen>>();
    protected IRenderingManager renderingManager;
    protected String[] renderingManagerClasses = new String[]{"gcewing.sg.BaseAORenderingManager", "gcewing.sg.BaseRenderingManager"};

    public BaseModClient(MOD mod) {
        this.base = mod;
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public void preInit(FMLPreInitializationEvent e) {
        this.registerSavedVillagerSkins();
        for (BaseSubsystem sub : ((BaseMod)this.base).subsystems) {
            sub.registerBlockRenderers();
            sub.registerItemRenderers();
        }
        if (this.renderingManager == null && this.renderingManagerRequired()) {
            this.getRenderingManager();
        }
        if (this.renderingManager != null) {
            this.renderingManager.preInit();
        }
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
        for (BaseSubsystem sub : ((BaseMod)this.base).subsystems) {
            sub.registerModelLocations();
            sub.registerTileEntityRenderers();
            sub.registerEntityRenderers();
            sub.registerScreens();
            sub.registerOtherClient();
        }
        if (this.renderingManager != null) {
            this.renderingManager.postInit();
        }
    }

    void registerSavedVillagerSkins() {
    }

    void registerOther() {
    }

    void registerScreens() {
    }

    public void addScreen(Enum id, Class<? extends GuiScreen> cls) {
        this.addScreen(id.ordinal(), cls);
    }

    public void addScreen(int id, Class<? extends GuiScreen> cls) {
        this.screenClasses.put(id, cls);
    }

    protected void registerBlockRenderers() {
    }

    protected void registerItemRenderers() {
    }

    protected void registerEntityRenderers() {
    }

    protected void registerTileEntityRenderers() {
    }

    public void addTileEntityRenderer(Class<? extends TileEntity> teClass, TileEntitySpecialRenderer renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(teClass, (TileEntitySpecialRenderer)renderer);
    }

    public void addEntityRenderer(Class<? extends Entity> entityClass, Render renderer) {
        RenderingRegistry.registerEntityRenderingHandler(entityClass, (Render)renderer);
    }

    public void addEntityRenderer(Class<? extends Entity> entityClass, Class<? extends Render> rendererClass) {
        Render renderer;
        try {
            renderer = rendererClass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.addEntityRenderer(entityClass, renderer);
    }

    public static void openClientGui(GuiScreen gui) {
        FMLClientHandler.instance().getClient().func_147108_a(gui);
    }

    public ResourceLocation textureLocation(String path) {
        return ((BaseMod)this.base).resourceLocation("textures/" + path);
    }

    public void bindTexture(String path) {
        BaseModClient.bindTexture(this.textureLocation(path));
    }

    public static void bindTexture(ResourceLocation rsrc) {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        tm.func_110577_a(rsrc);
    }

    public Object getServerGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return ((BaseMod)this.base).getServerGuiElement(id, player, world, x, y, z);
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, int x, int y, int z) {
        return this.getClientGuiElement(id, player, world, new BlockPos(x, y, z));
    }

    public Object getClientGuiElement(int id, EntityPlayer player, World world, BlockPos pos) {
        Class<? extends GuiScreen> scrnCls;
        int param = id >> 16;
        id &= 0xFFFF;
        Object result = null;
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: for id %s\n", id);
        }
        if ((scrnCls = this.screenClasses.get(id)) != null) {
            block14: {
                Class<? extends Container> contCls;
                if (((BaseMod)this.base).debugGui) {
                    System.out.printf("BaseModClient.getClientGuiElement: Instantiating %s\n", scrnCls);
                }
                if ((contCls = ((BaseMod)this.base).containerClasses.get(id)) != null) {
                    try {
                        Object cont;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Looking for constructor taking %s\n", contCls);
                        }
                        Constructor<? extends GuiScreen> ctor = scrnCls.getConstructor(contCls);
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating container\n", new Object[0]);
                        }
                        if ((cont = ((BaseMod)this.base).createGuiElement(contCls, player, world, pos, param)) == null) break block14;
                        if (((BaseMod)this.base).debugGui) {
                            System.out.printf("BaseModClient.getClientGuiElement: Instantiating screen with container\n", new Object[0]);
                        }
                        try {
                            result = ctor.newInstance(cont);
                        }
                        catch (Exception e) {
                            BaseMod.reportExceptionCause(e);
                            return null;
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (result == null) {
                result = ((BaseMod)this.base).createGuiElement(scrnCls, player, world, pos, param);
            }
        } else {
            result = this.getGuiScreen(id, player, world, pos, param);
        }
        ((BaseMod)this.base).setModOf(result);
        if (((BaseMod)this.base).debugGui) {
            System.out.printf("BaseModClient.getClientGuiElement: returning %s\n", result);
        }
        return result;
    }

    GuiScreen getGuiScreen(int id, EntityPlayer player, World world, BlockPos pos, int param) {
        System.out.printf("%s: BaseModClient.getGuiScreen: No GuiScreen class found for gui id %d\n", this, id);
        return null;
    }

    public void addBlockRenderer(Block block, ICustomRenderer renderer) {
        this.getRenderingManager().addBlockRenderer(block, renderer);
    }

    public void addItemRenderer(Item item, ICustomRenderer renderer) {
        this.getRenderingManager().addItemRenderer(item, renderer);
    }

    public IModel getModel(String name) {
        return this.getRenderingManager().getModel(name);
    }

    public ModelResourceLocation modelResourceLocation(String path, String variant) {
        return new ModelResourceLocation(((BaseMod)this.base).resourceLocation(path), variant);
    }

    public void registerModelLocations() {
    }

    protected Class lookForClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected IRenderingManager getRenderingManager() {
        if (this.renderingManager != null) {
            return this.renderingManager;
        }
        for (String name : this.renderingManagerClasses) {
            Class cls = this.lookForClass(name);
            if (cls == null) continue;
            try {
                Constructor con = cls.getConstructor(BaseModClient.class);
                this.renderingManager = (IRenderingManager)con.newInstance(this);
                return this.renderingManager;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No rendering manager found in package gcewing.sg");
    }

    protected boolean renderingManagerRequired() {
        for (Block block : ((BaseMod)this.base).registeredBlocks) {
            if (!this.objectNeedsCustomRendering(block)) continue;
            return true;
        }
        for (Item item : ((BaseMod)this.base).registeredItems) {
            if (!this.objectNeedsCustomRendering(item)) continue;
            return true;
        }
        return false;
    }

    protected boolean objectNeedsCustomRendering(Object obj) {
        return obj instanceof BaseMod.ITextureConsumer && ((BaseMod.ITextureConsumer)obj).getTextureNames() != null;
    }

    public static interface IModel {
        public AxisAlignedBB getBounds();

        public void addBoxesToList(Trans3 var1, List var2);

        public void render(Trans3 var1, IRenderTarget var2, ITexture ... var3);
    }

    public static interface IRenderTarget {
        public boolean isRenderingBreakEffects();

        public void setTexture(ITexture var1);

        public void setColor(double var1, double var3, double var5, double var7);

        public void setNormal(Vector3 var1);

        public void beginTriangle();

        public void beginQuad();

        public void addVertex(Vector3 var1, double var2, double var4);

        public void addProjectedVertex(Vector3 var1, EnumFacing var2);

        public void endFace();
    }

    public static interface ITiledTexture
    extends ITexture {
        public ITexture tile(int var1, int var2);
    }

    public static interface ITexture {
        public ResourceLocation location();

        public int tintIndex();

        public double red();

        public double green();

        public double blue();

        public double interpolateU(double var1);

        public double interpolateV(double var1);

        public boolean isEmissive();

        public boolean isProjected();

        public boolean isSolid();

        public ITexture tinted(int var1);

        public ITexture colored(double var1, double var3, double var5);

        public ITexture projected();

        public ITexture emissive();

        public ITiledTexture tiled(int var1, int var2);
    }

    public static interface ICustomRenderer {
        public void renderBlock(IBlockAccess var1, BlockPos var2, IBlockState var3, IRenderTarget var4, BlockRenderLayer var5, Trans3 var6);

        public void renderItemStack(ItemStack var1, IRenderTarget var2, Trans3 var3);
    }

    public static interface IRenderingManager {
        public void preInit();

        public void postInit();

        public void addBlockRenderer(Block var1, ICustomRenderer var2);

        public void addItemRenderer(Item var1, ICustomRenderer var2);

        public IModel getModel(String var1);
    }
}

