/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.service.proxy.api7;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.lucko.luckperms.common.util.ImmutableCollectors;
import me.lucko.luckperms.sponge.service.model.LPPermissionDescription;
import me.lucko.luckperms.sponge.service.model.LPPermissionService;
import me.lucko.luckperms.sponge.service.model.LPSubjectCollection;
import me.lucko.luckperms.sponge.service.model.ProxiedServiceObject;
import me.lucko.luckperms.sponge.service.proxy.api7.DescriptionBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.context.ContextCalculator;
import org.spongepowered.api.service.permission.PermissionDescription;
import org.spongepowered.api.service.permission.PermissionService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectCollection;
import org.spongepowered.api.service.permission.SubjectReference;

public final class PermissionServiceProxy
implements PermissionService,
ProxiedServiceObject {
    private final LPPermissionService handle;

    public PermissionServiceProxy(LPPermissionService handle) {
        this.handle = handle;
    }

    public @NonNull SubjectCollection getUserSubjects() {
        return this.handle.getUserSubjects().sponge();
    }

    public @NonNull SubjectCollection getGroupSubjects() {
        return this.handle.getGroupSubjects().sponge();
    }

    public @NonNull Subject getDefaults() {
        return this.handle.getRootDefaults().sponge();
    }

    public @NonNull Predicate<String> getIdentifierValidityPredicate() {
        return this.handle.getIdentifierValidityPredicate();
    }

    public CompletableFuture<SubjectCollection> loadCollection(@NonNull String s) {
        return CompletableFuture.completedFuture(this.handle.getCollection(s).sponge());
    }

    public @NonNull Optional<SubjectCollection> getCollection(String s) {
        return Optional.ofNullable((LPSubjectCollection)this.handle.getLoadedCollections().get((Object)s.toLowerCase())).map(LPSubjectCollection::sponge);
    }

    public CompletableFuture<Boolean> hasCollection(String s) {
        return CompletableFuture.completedFuture(this.handle.getLoadedCollections().containsKey((Object)s.toLowerCase()));
    }

    public @NonNull Map<String, SubjectCollection> getLoadedCollections() {
        return (Map)this.handle.getLoadedCollections().entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> ((LPSubjectCollection)e.getValue()).sponge()));
    }

    public CompletableFuture<Set<String>> getAllIdentifiers() {
        return CompletableFuture.completedFuture(ImmutableSet.copyOf((Collection)this.handle.getLoadedCollections().keySet()));
    }

    public @NonNull SubjectReference newSubjectReference(@NonNull String collectionIdentifier, @NonNull String subjectIdentifier) {
        Objects.requireNonNull(collectionIdentifier, "collectionIdentifier");
        Objects.requireNonNull(subjectIdentifier, "subjectIdentifier");
        String collection = collectionIdentifier.toLowerCase();
        if (collection.equals("user") && !this.handle.getUserSubjects().getIdentifierValidityPredicate().test(subjectIdentifier)) {
            throw new IllegalArgumentException("Subject identifier '" + subjectIdentifier + "' does not pass the validity predicate for the user subject collection");
        }
        if (collection.equals("group") && !this.handle.getGroupSubjects().getIdentifierValidityPredicate().test(subjectIdentifier)) {
            throw new IllegalArgumentException("Subject identifier '" + subjectIdentifier + "' does not pass the validity predicate for the group subject collection");
        }
        return this.handle.getReferenceFactory().obtain(collectionIdentifier, subjectIdentifier);
    }

    public PermissionDescription.Builder newDescriptionBuilder(@NonNull Object o) {
        Optional container = Sponge.getGame().getPluginManager().fromInstance(o);
        if (!container.isPresent()) {
            throw new IllegalArgumentException("Couldn't find a plugin container for " + o.getClass().getSimpleName());
        }
        return new DescriptionBuilder(this.handle, (PluginContainer)container.get());
    }

    public @NonNull Optional<PermissionDescription> getDescription(@NonNull String s) {
        return this.handle.getDescription(s).map(LPPermissionDescription::sponge);
    }

    public @NonNull Collection<PermissionDescription> getDescriptions() {
        return (Collection)this.handle.getDescriptions().stream().map(LPPermissionDescription::sponge).collect(ImmutableCollectors.toSet());
    }

    public void registerContextCalculator(@NonNull ContextCalculator<Subject> contextCalculator) {
        this.handle.registerContextCalculator(contextCalculator);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof PermissionServiceProxy && this.handle.equals(((PermissionServiceProxy)o).handle);
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public String toString() {
        return "luckperms.api7.PermissionServiceProxy(handle=" + this.handle + ")";
    }
}

