/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge;

import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.stream.Collectors;
import me.lucko.luckperms.common.command.CommandManager;
import me.lucko.luckperms.common.command.utils.ArgumentTokenizer;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.selector.Selector;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeCommandExecutor
extends CommandManager
implements CommandCallable {
    private final LPSpongePlugin plugin;

    public SpongeCommandExecutor(LPSpongePlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    public @NonNull CommandResult process(@NonNull CommandSource source, @NonNull String args) {
        Sender wrapped = this.plugin.getSenderFactory().wrap(source);
        List<String> arguments = this.resolveSelectors(source, ArgumentTokenizer.EXECUTE.tokenizeInput(args));
        this.executeCommand(wrapped, "lp", arguments);
        return CommandResult.success();
    }

    public @NonNull List<String> getSuggestions(@NonNull CommandSource source, @NonNull String args, @Nullable Location<World> location) {
        Sender wrapped = this.plugin.getSenderFactory().wrap(source);
        List<String> arguments = this.resolveSelectors(source, ArgumentTokenizer.TAB_COMPLETE.tokenizeInput(args));
        return this.tabCompleteCommand(wrapped, arguments);
    }

    public boolean testPermission(@NonNull CommandSource source) {
        return true;
    }

    public @NonNull Optional<Text> getShortDescription(@NonNull CommandSource source) {
        return Optional.of(Text.of((String)"Manage permissions"));
    }

    public @NonNull Optional<Text> getHelp(@NonNull CommandSource source) {
        return Optional.of(Text.of((String)"Run /luckperms to view usage."));
    }

    public @NonNull Text getUsage(@NonNull CommandSource source) {
        return Text.of((String)"/luckperms");
    }

    private List<String> resolveSelectors(CommandSource source, List<String> args) {
        if (!this.plugin.getConfiguration().get(ConfigKeys.RESOLVE_COMMAND_SELECTORS).booleanValue()) {
            return args;
        }
        ListIterator<String> it = args.listIterator();
        while (it.hasNext()) {
            List matchedPlayers;
            String arg = it.next();
            if (arg.isEmpty() || arg.charAt(0) != '@') continue;
            try {
                matchedPlayers = Selector.parse((String)arg).resolve(source).stream().filter(e -> e instanceof Player).map(e -> (Player)e).collect(Collectors.toList());
            }
            catch (IllegalArgumentException e2) {
                this.plugin.getLogger().warn("Error parsing selector '" + arg + "' for " + source + " executing " + args, e2);
                continue;
            }
            if (matchedPlayers.isEmpty()) continue;
            if (matchedPlayers.size() > 1) {
                this.plugin.getLogger().warn("Error parsing selector '" + arg + "' for " + source + " executing " + args + ": ambiguous result (more than one player matched) - " + matchedPlayers);
                continue;
            }
            Player player = (Player)matchedPlayers.get(0);
            it.set(player.getUniqueId().toString());
        }
        return args;
    }
}

