/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose.event;

import com.google.gson.JsonObject;
import java.util.Objects;
import me.lucko.luckperms.common.util.StackTracePrinter;
import me.lucko.luckperms.common.util.gson.JArray;
import me.lucko.luckperms.common.util.gson.JObject;
import me.lucko.luckperms.common.verbose.expression.BooleanExpressionCompiler;
import net.luckperms.api.context.Context;
import net.luckperms.api.query.QueryMode;
import net.luckperms.api.query.QueryOptions;

public abstract class VerboseEvent
implements BooleanExpressionCompiler.VariableEvaluator {
    private final String checkTarget;
    private final QueryOptions checkQueryOptions;
    private final long checkTime;
    private final Throwable checkTrace;
    private final String checkThread;

    protected VerboseEvent(String checkTarget, QueryOptions checkQueryOptions, long checkTime, Throwable checkTrace, String checkThread) {
        this.checkTarget = checkTarget;
        this.checkQueryOptions = checkQueryOptions;
        this.checkTime = checkTime;
        this.checkTrace = checkTrace;
        this.checkThread = checkThread;
    }

    public String getCheckTarget() {
        return this.checkTarget;
    }

    public QueryOptions getCheckQueryOptions() {
        return this.checkQueryOptions;
    }

    public long getCheckTime() {
        return this.checkTime;
    }

    public StackTraceElement[] getCheckTrace() {
        return this.checkTrace.getStackTrace();
    }

    public String getCheckThread() {
        return this.checkThread;
    }

    protected abstract void serializeTo(JObject var1);

    public JsonObject toJson(StackTracePrinter tracePrinter) {
        return new JObject().add("who", new JObject().add("identifier", this.checkTarget)).add("queryMode", this.checkQueryOptions.mode().name().toLowerCase()).consume(obj -> {
            if (this.checkQueryOptions.mode() == QueryMode.CONTEXTUAL) {
                obj.add("context", new JArray().consume(arr -> {
                    for (Context contextPair : Objects.requireNonNull(this.checkQueryOptions.context())) {
                        arr.add(new JObject().add("key", contextPair.getKey()).add("value", contextPair.getValue()));
                    }
                }));
            }
        }).add("time", this.checkTime).add("trace", new JArray().consume(arr -> {
            int overflow = tracePrinter.process(this.getCheckTrace(), StackTracePrinter.elementToString(arr::add));
            if (overflow != 0) {
                arr.add("... and " + overflow + " more");
            }
        })).add("thread", this.checkThread).consume(this::serializeTo).toJson();
    }
}

