/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.file.watcher;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.storage.implementation.file.watcher.AbstractFileWatcher;
import me.lucko.luckperms.common.util.ExpiringSet;
import me.lucko.luckperms.common.util.Iterators;

public class FileWatcher
extends AbstractFileWatcher {
    private final Path basePath;
    private final Map<Path, WatchedLocation> watchedLocations = Collections.synchronizedMap(new HashMap());

    public FileWatcher(LuckPermsPlugin plugin, Path basePath) throws IOException {
        super(basePath.getFileSystem(), true);
        this.basePath = basePath;
        super.registerRecursively(basePath);
        plugin.getBootstrap().getScheduler().executeAsync(() -> super.runEventProcessingLoop());
    }

    public WatchedLocation getWatcher(Path path) {
        if (path.isAbsolute()) {
            path = this.basePath.relativize(path);
        }
        return this.watchedLocations.computeIfAbsent(path, WatchedLocation::new);
    }

    @Override
    protected void processEvent(WatchEvent<Path> event, Path path) {
        Path relativePath = this.basePath.relativize(path);
        if (relativePath.getNameCount() == 0) {
            return;
        }
        for (Map.Entry<Path, WatchedLocation> entry : this.watchedLocations.entrySet()) {
            if (!relativePath.startsWith(entry.getKey())) continue;
            entry.getValue().onEvent(event, relativePath);
        }
    }

    public static final class WatchedLocation {
        private final Path path;
        private final Set<String> recentlyModifiedFiles = new ExpiringSet(4L, TimeUnit.SECONDS);
        private final List<Consumer<Path>> callbacks = new CopyOnWriteArrayList<Consumer<Path>>();

        WatchedLocation(Path path) {
            this.path = path;
        }

        void onEvent(WatchEvent<Path> event, Path path) {
            Path relativePath = this.path.relativize(path);
            String fileName = relativePath.toString();
            if (!this.recentlyModifiedFiles.add(fileName)) {
                return;
            }
            Iterators.tryIterate(this.callbacks, cb -> cb.accept(relativePath));
        }

        public void recordChange(String fileName) {
            this.recentlyModifiedFiles.add(fileName);
        }

        public void addListener(Consumer<Path> listener) {
            this.callbacks.add(listener);
        }
    }
}

